/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarVersionDetectionUtil {
    @NonNls
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";

    private JarVersionDetectionUtil() {
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull Module module) {
        if (detectionClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/libraries/JarVersionDetectionUtil.detectJarVersion must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/libraries/JarVersionDetectionUtil.detectJarVersion must not be null");
        }
        try {
            ZipFile zipFile = JarVersionDetectionUtil.getDetectionJar(detectionClass, module);
            if (zipFile == null) {
                return null;
            }
            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private static ZipFile getDetectionJar(String detectionClass, Module module) throws IOException {
        for (OrderEntry library : ModuleRootManager.getInstance(module).getOrderEntries()) {
            VirtualFile file;
            if (!(library instanceof LibraryOrderEntry) || (file = LibrariesHelper.getInstance().findJarByClass(((LibraryOrderEntry)library).getLibrary(), detectionClass)) == null || !(file.getFileSystem() instanceof JarFileSystem)) continue;
            return JarFileSystem.getInstance().getJarFile(file);
        }
        return null;
    }
}

