/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;

public class IdeaSpecificSettings {
    @NonNls
    private static final String RELATIVE_MODULE_SRC = "relative-module-src";
    @NonNls
    private static final String RELATIVE_MODULE_CLS = "relative-module-cls";
    @NonNls
    private static final String RELATIVE_MODULE_JAVADOC = "relative-module-javadoc";
    @NonNls
    private static final String PROJECT_RELATED = "project-related";
    @NonNls
    private static final String SRCROOT_ATTR = "srcroot";
    private static final Logger LOG = Logger.getInstance((String)("#" + IdeaSpecificSettings.class.getName()));

    private IdeaSpecificSettings() {
    }

    public static void readIDEASpecific(Element root, ModifiableRootModel model) throws InvalidDataException {
        String inheritedOutput;
        PathMacroManager.getInstance((ComponentManager)model.getModule()).expandPaths(root);
        ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).readExternal(root);
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
        Element testOutputElement = root.getChild("output-test");
        if (testOutputElement != null) {
            compilerModuleExtension.setCompilerOutputPathForTests(testOutputElement.getAttributeValue("url"));
        }
        if ((inheritedOutput = root.getAttributeValue("inherit-compiler-output")) != null && Boolean.valueOf(inheritedOutput).booleanValue()) {
            compilerModuleExtension.inheritCompilerOutputPath(true);
        }
        compilerModuleExtension.setExcludeOutput(root.getChild("exclude-output") != null);
        List entriesElements = root.getChildren("contentEntry");
        if (!entriesElements.isEmpty()) {
            for (Object o : entriesElements) {
                IdeaSpecificSettings.readContentEntry((Element)o, model.addContentEntry(((Element)o).getAttributeValue("url")));
            }
        } else {
            ContentEntry[] entries = model.getContentEntries();
            if (entries.length > 0) {
                IdeaSpecificSettings.readContentEntry(root, entries[0]);
            }
        }
        for (Object o : root.getChildren("lib")) {
            Library[] libraries;
            Element libElement = (Element)o;
            String libName = libElement.getAttributeValue("name");
            Library libraryByName = model.getModuleLibraryTable().getLibraryByName(libName);
            if (libraryByName != null) {
                IdeaSpecificSettings.appendLibraryScope(model, libElement, libraryByName);
                Library.ModifiableModel modifiableModel = libraryByName.getModifiableModel();
                IdeaSpecificSettings.replaceCollapsedByEclipseSourceRoots(libElement, modifiableModel);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, OrderRootType.SOURCES, RELATIVE_MODULE_SRC);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, OrderRootType.CLASSES, RELATIVE_MODULE_CLS);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, JavadocOrderRootType.getInstance(), RELATIVE_MODULE_JAVADOC);
                modifiableModel.commit();
                continue;
            }
            libraryByName = EclipseClasspathReader.findLibraryByName(model.getProject(), libName);
            if (libraryByName != null) {
                IdeaSpecificSettings.appendLibraryScope(model, libElement, libraryByName);
            }
            for (Library library : libraries = model.getModuleLibraryTable().getLibraries()) {
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                IdeaSpecificSettings.replaceCollapsedByEclipseSourceRoots(libElement, modifiableModel);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, OrderRootType.SOURCES, RELATIVE_MODULE_SRC);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, OrderRootType.CLASSES, RELATIVE_MODULE_CLS);
                IdeaSpecificSettings.replaceModuleRelatedRoots(model.getProject(), modifiableModel, libElement, JavadocOrderRootType.getInstance(), RELATIVE_MODULE_JAVADOC);
                modifiableModel.commit();
            }
        }
    }

    private static void appendLibraryScope(ModifiableRootModel model, Element libElement, Library libraryByName) {
        LibraryOrderEntry libraryOrderEntry = model.findLibraryOrderEntry(libraryByName);
        if (libraryOrderEntry != null) {
            String scopeAttribute = libElement.getAttributeValue("scope");
            libraryOrderEntry.setScope(scopeAttribute == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)scopeAttribute));
        }
    }

    private static void replaceCollapsedByEclipseSourceRoots(Element libElement, Library.ModifiableModel modifiableModel) {
        String[] srcUrlsFromClasspath = modifiableModel.getUrls(OrderRootType.SOURCES);
        LOG.assertTrue(srcUrlsFromClasspath.length <= 1);
        for (Object r : libElement.getChildren(SRCROOT_ATTR)) {
            String url = ((Element)r).getAttributeValue("url");
            modifiableModel.addRoot(url, OrderRootType.SOURCES);
            if (srcUrlsFromClasspath == null || srcUrlsFromClasspath.length != 1 || !EPathUtil.areUrlsPointTheSame(url, srcUrlsFromClasspath[0])) continue;
            modifiableModel.removeRoot(srcUrlsFromClasspath[0], OrderRootType.SOURCES);
            srcUrlsFromClasspath = null;
        }
    }

    public static void readContentEntry(Element root, ContentEntry entry) {
        for (Object o : root.getChildren("testFolder")) {
            String url = ((Element)o).getAttributeValue("url");
            SourceFolder folderToBeTest = null;
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!Comparing.strEqual((String)folder.getUrl(), (String)url)) continue;
                folderToBeTest = folder;
                break;
            }
            if (folderToBeTest != null) {
                entry.removeSourceFolder(folderToBeTest);
            }
            entry.addSourceFolder(url, true);
        }
        String url = entry.getUrl();
        for (Object o : root.getChildren("excludeFolder")) {
            String excludeUrl = ((Element)o).getAttributeValue("url");
            try {
                if (!FileUtil.isAncestor((File)new File(url), (File)new File(excludeUrl), (boolean)false)) continue;
                entry.addExcludeFolder(excludeUrl);
            }
            catch (IOException e) {}
        }
    }

    public static boolean writeIDEASpecificClasspath(Element root, ModuleRootModel model) throws WriteExternalException {
        LanguageLevelModuleExtension languageLevelModuleExtension;
        LanguageLevel languageLevel;
        boolean isModified = false;
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
        if (compilerModuleExtension.getCompilerOutputPathForTests() != null) {
            Element pathElement = new Element("output-test");
            pathElement.setAttribute("url", compilerModuleExtension.getCompilerOutputUrlForTests());
            root.addContent(pathElement);
            isModified = true;
        }
        if (compilerModuleExtension.isCompilerOutputPathInherited()) {
            root.setAttribute("inherit-compiler-output", String.valueOf(true));
            isModified = true;
        }
        if (compilerModuleExtension.isExcludeOutput()) {
            root.addContent(new Element("exclude-output"));
            isModified = true;
        }
        if ((languageLevel = (languageLevelModuleExtension = (LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).getLanguageLevel()) != null) {
            languageLevelModuleExtension.writeExternal(root);
            isModified = true;
        }
        for (ContentEntry contentEntry : model.getContentEntries()) {
            Element contentEntryElement = new Element("contentEntry");
            contentEntryElement.setAttribute("url", contentEntry.getUrl());
            root.addContent(contentEntryElement);
            for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                if (!sourceFolder.isTestSource()) continue;
                Element element = new Element("testFolder");
                contentEntryElement.addContent(element);
                element.setAttribute("url", sourceFolder.getUrl());
                isModified = true;
            }
            VirtualFile entryFile = contentEntry.getFile();
            for (ExcludeFolder excludeFolder : contentEntry.getExcludeFolders()) {
                String exludeFolderUrl = excludeFolder.getUrl();
                VirtualFile excludeFile = excludeFolder.getFile();
                if (entryFile != null && excludeFile != null && !VfsUtil.isAncestor((VirtualFile)entryFile, (VirtualFile)excludeFile, (boolean)false)) continue;
                Element element = new Element("excludeFolder");
                contentEntryElement.addContent(element);
                element.setAttribute("url", exludeFolderUrl);
                isModified = true;
            }
        }
        for (ContentEntry contentEntry : model.getOrderEntries()) {
            if (!(contentEntry instanceof LibraryOrderEntry)) continue;
            Element element = new Element("lib");
            element.setAttribute("name", contentEntry.getPresentableName());
            DependencyScope scope = ((LibraryOrderEntry)contentEntry).getScope();
            element.setAttribute("scope", scope.name());
            if (((LibraryOrderEntry)contentEntry).isModuleLevel()) {
                VirtualFile virtualFile;
                String[] urls = contentEntry.getUrls(OrderRootType.SOURCES);
                if (urls.length > 1) {
                    for (String url : urls) {
                        Element srcElement = new Element(SRCROOT_ATTR);
                        srcElement.setAttribute("url", url);
                        element.addContent(srcElement);
                    }
                } else if (urls.length == 1 && urls[0].contains("!/") && (virtualFile = JarFileSystem.getInstance().findFileByPath(VfsUtil.urlToPath((String)urls[0]))) != null) {
                    Element srcElement = new Element(SRCROOT_ATTR);
                    srcElement.setAttribute("url", urls[0]);
                    element.addContent(srcElement);
                }
                for (String srcUrl : contentEntry.getUrls(OrderRootType.SOURCES)) {
                    IdeaSpecificSettings.appendModuleRelatedRoot(element, srcUrl, RELATIVE_MODULE_SRC, model);
                }
                for (String classesUrl : contentEntry.getUrls(OrderRootType.CLASSES)) {
                    IdeaSpecificSettings.appendModuleRelatedRoot(element, classesUrl, RELATIVE_MODULE_CLS, model);
                }
                for (String javadocUrl : contentEntry.getUrls(JavadocOrderRootType.getInstance())) {
                    IdeaSpecificSettings.appendModuleRelatedRoot(element, javadocUrl, RELATIVE_MODULE_JAVADOC, model);
                }
                if (!element.getChildren().isEmpty()) {
                    root.addContent(element);
                    isModified = true;
                    continue;
                }
            }
            if (scope.equals((Object)DependencyScope.COMPILE)) continue;
            root.addContent(element);
            isModified = true;
        }
        PathMacroManager.getInstance((ComponentManager)model.getModule()).collapsePaths(root);
        return isModified;
    }

    public static void replaceModuleRelatedRoots(Project project, Library.ModifiableModel modifiableModel, Element libElement, OrderRootType orderRootType, String relativeModuleName) {
        ArrayList<String> urls = new ArrayList<String>(Arrays.asList(modifiableModel.getUrls(orderRootType)));
        block0: for (Object r : libElement.getChildren(relativeModuleName)) {
            String root = PathMacroManager.getInstance((ComponentManager)project).expandPath(((Element)r).getAttributeValue(PROJECT_RELATED));
            Iterator iterator = urls.iterator();
            while (iterator.hasNext()) {
                String url = (String)iterator.next();
                if (!EPathUtil.areUrlsPointTheSame(root, url)) continue;
                iterator.remove();
                modifiableModel.removeRoot(url, orderRootType);
                modifiableModel.addRoot(root, orderRootType);
                continue block0;
            }
        }
    }

    public static boolean appendModuleRelatedRoot(Element element, String classesUrl, String rootName, ModuleRootModel model) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(classesUrl);
        if (file != null) {
            Project project;
            Module module;
            if (file.getFileSystem() instanceof JarFileSystem) {
                file = JarFileSystem.getInstance().getVirtualFileForJar(file);
                assert (file != null);
            }
            if ((module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)(project = model.getModule().getProject()))) != null) {
                return IdeaSpecificSettings.appendRelatedToModule(element, classesUrl, rootName, file, module);
            }
            if (ProjectRootManager.getInstance((Project)project).getFileIndex().isIgnored(file)) {
                for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
                    if (!IdeaSpecificSettings.appendRelatedToModule(element, classesUrl, rootName, file, aModule)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean appendRelatedToModule(Element element, String classesUrl, String rootName, VirtualFile file, Module module) {
        VirtualFile[] contentRoots;
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
            Element clsElement = new Element(rootName);
            clsElement.setAttribute(PROJECT_RELATED, PathMacroManager.getInstance((ComponentManager)module.getProject()).collapsePath(classesUrl));
            element.addContent(clsElement);
            return true;
        }
        return false;
    }
}

