/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public class GroovyNameSuggestionUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil");

    public static String[] suggestVariableNames(GrExpression expr, NameValidator validator) {
        ArrayList<String> possibleNames = new ArrayList<String>();
        PsiType type = expr.getType();
        GroovyNameSuggestionUtil.generateNameByExpr(expr, possibleNames, validator);
        if (type != null && !PsiType.VOID.equals(type)) {
            String unboxed = PsiTypesUtil.unboxIfPossible((String)type.getCanonicalText());
            if (unboxed != null && !unboxed.equals(type.getCanonicalText())) {
                String name = GroovyNameSuggestionUtil.generateNameForBuiltInType(unboxed);
                if (GroovyNamesUtil.isIdentifier(name = validator.validateName(name, true))) {
                    possibleNames.add(name);
                }
            } else {
                GroovyNameSuggestionUtil.generateByType(expr.getType(), possibleNames, validator);
            }
        }
        while (possibleNames.contains("")) {
            possibleNames.remove("");
        }
        if (possibleNames.size() == 0) {
            possibleNames.add(validator.validateName("var", true));
        }
        return ArrayUtil.toStringArray(possibleNames);
    }

    private static void generateNameByExpr(GrExpression expr, ArrayList<String> possibleNames, NameValidator validator) {
        if (expr instanceof GrThisReferenceExpression) {
            possibleNames.add(validator.validateName("thisInstance", true));
        }
        if (expr instanceof GrSuperReferenceExpression) {
            possibleNames.add(validator.validateName("superInstance", true));
        }
        if (expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).getName() != null) {
            GrReferenceExpression refExpr = (GrReferenceExpression)expr;
            String name = refExpr.getName();
            if (name != null && name.toUpperCase().equals(name)) {
                possibleNames.add(validator.validateName(name.toLowerCase(), true));
            } else {
                GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, name);
            }
            if (expr.getText().equals(name)) {
                possibleNames.remove(name);
            }
        }
        if (expr instanceof GrMethodCallExpression) {
            GroovyNameSuggestionUtil.generateNameByExpr(((GrMethodCallExpression)expr).getInvokedExpression(), possibleNames, validator);
        }
    }

    private static void generateByType(PsiType type, ArrayList<String> possibleNames, NameValidator validator) {
        String typeName = type.getPresentableText();
        GroovyNameSuggestionUtil.generateNamesForCollectionType(type, possibleNames, validator);
        GroovyNameSuggestionUtil.generateNamesForArrayType(type, possibleNames, validator);
        typeName = GroovyNameSuggestionUtil.cleanTypeName(typeName);
        if (typeName.equals("String")) {
            possibleNames.add(validator.validateName("s", true));
        }
        if (typeName.equals("Closure")) {
            possibleNames.add(validator.validateName("cl", true));
        }
        if (typeName.toUpperCase().equals(typeName)) {
            possibleNames.add(validator.validateName(GroovyNamesUtil.deleteNonLetterFromString(typeName.toLowerCase()), true));
        } else if (!typeName.equals(typeName.toLowerCase())) {
            GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, typeName);
            possibleNames.remove(typeName);
        }
    }

    private static void generateNamesForArrayType(PsiType type, ArrayList<String> possibleNames, NameValidator validator) {
        int arrayDim = type.getArrayDimensions();
        if (arrayDim == 0) {
            return;
        }
        PsiType deepType = type.getDeepComponentType();
        String candidateName = GroovyNameSuggestionUtil.cleanTypeName(deepType.getPresentableText());
        if (deepType instanceof PsiClassType) {
            PsiClass clazz = ((PsiClassType)deepType).resolve();
            if (clazz == null) {
                return;
            }
            candidateName = GroovyNamesUtil.fromLowerLetter(clazz.getName());
        }
        candidateName = StringUtil.pluralize((String)GroovyNamesUtil.fromLowerLetter(candidateName));
        GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, candidateName);
        ArrayList<String> camelizedName = GroovyNamesUtil.camelizeString(candidateName);
        candidateName = camelizedName.get(camelizedName.size() - 1);
        candidateName = "arrayOf" + GroovyNameSuggestionUtil.fromUpperLetter(candidateName);
        possibleNames.add(validator.validateName(candidateName, true));
    }

    private static void generateNamesForCollectionType(PsiType type, ArrayList<String> possibleNames, NameValidator validator) {
        PsiType componentType = GroovyNameSuggestionUtil.getCollectionComponentType(type, validator.getProject());
        if (!(type instanceof PsiClassType) || componentType == null) {
            return;
        }
        PsiClass clazz = ((PsiClassType)type).resolve();
        if (clazz == null) {
            return;
        }
        String collectionName = clazz.getName();
        assert (collectionName != null);
        String componentName = GroovyNameSuggestionUtil.cleanTypeName(componentType.getPresentableText());
        if (componentType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)componentType;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) {
                return;
            }
            componentName = psiClass.getName();
        }
        assert (componentName != null);
        String candidateName = StringUtil.pluralize((String)GroovyNamesUtil.fromLowerLetter(componentName));
        GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, candidateName);
        ArrayList<String> camelizedName = GroovyNamesUtil.camelizeString(candidateName);
        candidateName = camelizedName.get(camelizedName.size() - 1);
        candidateName = collectionName.toLowerCase() + "Of" + GroovyNameSuggestionUtil.fromUpperLetter(candidateName);
        possibleNames.add(validator.validateName(candidateName, true));
    }

    @NotNull
    private static String cleanTypeName(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil.cleanTypeName must not be null");
        }
        if (typeName.contains(".")) {
            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        if (typeName.contains("<")) {
            typeName = typeName.substring(0, typeName.indexOf("<"));
        }
        String string = typeName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil.cleanTypeName must not return null");
        }
        return string;
    }

    private static void generateCamelNames(ArrayList<String> possibleNames, NameValidator validator, String typeName) {
        ArrayList<String> camelTokens = GroovyNamesUtil.camelizeString(typeName);
        Collections.reverse(camelTokens);
        if (camelTokens.size() > 0) {
            String possibleName = "";
            for (String camelToken : camelTokens) {
                possibleName = camelToken + GroovyNameSuggestionUtil.fromUpperLetter(possibleName);
                String candidate = validator.validateName(possibleName, true);
                if (candidate.equals("class")) {
                    candidate = validator.validateName("clazz", true);
                }
                if (possibleNames.contains(candidate) || !GroovyNamesUtil.isIdentifier(candidate)) continue;
                possibleNames.add(candidate);
            }
        }
    }

    private static String generateNameForBuiltInType(String unboxed) {
        return unboxed.toLowerCase().substring(0, 1);
    }

    private static String fromUpperLetter(String str) {
        if (str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static PsiType getCollectionComponentType(PsiType type, Project project) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClassType.ClassResolveResult result = classType.resolveGenerics();
        PsiClass clazz = result.getElement();
        if (clazz == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass collectionClass = facade.findClass("java.util.Collection", ((PsiClassType)type).getResolveScope());
        if (collectionClass == null || collectionClass.getTypeParameters().length != 1) {
            return null;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)collectionClass, (PsiClass)clazz, (PsiSubstitutor)result.getSubstitutor());
        if (substitutor == null) {
            return null;
        }
        PsiType componentType = substitutor.substitute(collectionClass.getTypeParameters()[0]);
        return componentType instanceof PsiIntersectionType ? null : componentType;
    }
}

