/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.noncode;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticConstructor;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersProcessor;

public class ImmutableAnnotationProcessor
implements NonCodeMembersProcessor {
    @Override
    public boolean processNonCodeMembers(PsiType type, PsiScopeProcessor processor, PsiElement place, boolean forCompletion) {
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return true;
        }
        if (!(psiClass instanceof GrTypeDefinition)) {
            return true;
        }
        GrTypeDefinition grClass = (GrTypeDefinition)psiClass;
        GrModifierList modifierList = grClass.getModifierList();
        if (modifierList == null) {
            return true;
        }
        assert (modifierList instanceof GrModifierList);
        GrAnnotation[] annotations = modifierList.getAnnotations();
        GrField[] fields = grClass.getFields();
        ArrayList<String> paramTypes = new ArrayList<String>();
        ArrayList<String> paramNames = new ArrayList<String>();
        for (GrField grField : fields) {
            paramTypes.add(grField.getType().getCanonicalText());
            paramNames.add(grField.getName());
        }
        for (GroovyPsiElement groovyPsiElement : annotations) {
            if (!"groovy.lang.Immutable".equals(groovyPsiElement.getQualifiedName())) continue;
            String name = grClass.getName();
            if (name == null) {
                return true;
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(groovyPsiElement.getProject());
            GrMethod constructor = factory.createConstructorFromText(name, ArrayUtil.toStringArray(paramTypes), ArrayUtil.toStringArray(paramNames), "{}");
            if (!processor.execute((PsiElement)new GrSyntheticConstructor(constructor, grClass), ResolveState.initial())) {
                return false;
            }
            constructor = factory.createConstructorFromText(name, ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, "{}");
            return processor.execute((PsiElement)new GrSyntheticConstructor(constructor, grClass), ResolveState.initial());
        }
        return true;
    }
}

