/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrBinaryExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrMultiplicativeExpressionImpl
extends GrBinaryExpressionImpl {
    private static final String DOUBLE_FQ_NAME = "java.lang.Double";
    private static final String FLOAT_FQ_NAME = "java.lang.Float";

    public GrMultiplicativeExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrMultiplicativeExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "Multiplicative expression";
    }

    @Override
    public PsiType getType() {
        GrExpression lop = this.getLeftOperand();
        if (this.findChildByType(GroovyElementTypes.mDIV) != null) {
            PsiType rType;
            PsiType lType;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (lop != null && (lType = lop.getType()) != null && this.isDoubleOrFloat(lType)) {
                return factory.createTypeByFQClassName(DOUBLE_FQ_NAME, this.getResolveScope());
            }
            GrExpression rop = this.getRightOperand();
            if (rop != null && (rType = rop.getType()) != null && this.isDoubleOrFloat(rType)) {
                return factory.createTypeByFQClassName(DOUBLE_FQ_NAME, this.getResolveScope());
            }
            return factory.createTypeByFQClassName("java.math.BigDecimal", this.getResolveScope());
        }
        return TypesUtil.getNumericResultType(this, lop == null ? null : lop.getType());
    }

    private boolean isDoubleOrFloat(PsiType type) {
        return type.equalsToText(DOUBLE_FQ_NAME) || type.equalsToText(FLOAT_FQ_NAME);
    }
}

