/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.ErrorUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class ConvertConcatenationToGstringIntention
extends Intention {
    private static final String END_BRACE = "}";
    private static final String START_BRACE = "${";

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertConcatenationToGstringIntention.getElementPredicate must not return null");
        }
        return myPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertConcatenationToGstringIntention.processIntention must not be null");
        }
        StringBuilder builder = new StringBuilder(element.getTextLength());
        ConvertConcatenationToGstringIntention.performIntention((GrBinaryExpression)element, builder);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrExpression newExpr = factory.createExpressionFromText(GrStringUtil.addQuotes(builder.toString(), true));
        GrExpression expression = ((GrBinaryExpression)element).replaceWithExpression(newExpr, true);
        if (expression instanceof GrString) {
            GrStringUtil.removeUnnecessaryBracesInGString((GrString)expression);
        }
    }

    private static void performIntention(GrBinaryExpression expr, StringBuilder builder) {
        GrExpression left = (GrExpression)ConvertConcatenationToGstringIntention.skipParentheses(expr.getLeftOperand(), false);
        GrExpression right = (GrExpression)ConvertConcatenationToGstringIntention.skipParentheses(expr.getRightOperand(), false);
        ConvertConcatenationToGstringIntention.getOperandText(left, builder);
        ConvertConcatenationToGstringIntention.getOperandText(right, builder);
    }

    private static void getOperandText(GrExpression operand, StringBuilder builder) {
        if (operand instanceof GrString) {
            builder.append(GrStringUtil.removeQuotes(operand.getText()));
        } else if (operand instanceof GrLiteral) {
            String text = GrStringUtil.escapeSymbolsForGString(GrStringUtil.removeQuotes(operand.getText()), false);
            if (text.contains("\n")) {
                text = GrStringUtil.escapeSymbolsForGString(text, true);
            }
            builder.append(text);
        } else if (MyPredicate.satisfiedBy(operand, false)) {
            ConvertConcatenationToGstringIntention.performIntention((GrBinaryExpression)operand, builder);
        } else if (!ConvertConcatenationToGstringIntention.isToStringMethod(operand, builder)) {
            builder.append(START_BRACE).append(operand.getText()).append(END_BRACE);
        }
    }

    private static boolean isToStringMethod(GrExpression operand, StringBuilder builder) {
        if (!(operand instanceof GrMethodCallExpression)) {
            return false;
        }
        GrExpression expression = ((GrMethodCallExpression)operand).getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)expression;
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        GroovyResolveResult[] results = refExpr.multiResolve(false);
        if (results.length != 1) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiClass objectClass = JavaPsiFacade.getInstance((Project)operand.getProject()).findClass("java.lang.Object", operand.getResolveScope());
        if (objectClass == null) {
            return false;
        }
        PsiMethod[] toStringMethod = objectClass.findMethodsByName("toString", true);
        if (MethodSignatureUtil.isSubsignature((MethodSignature)toStringMethod[0].getHierarchicalMethodSignature(), (MethodSignature)method.getHierarchicalMethodSignature())) {
            builder.append(START_BRACE).append(qualifier.getText()).append(END_BRACE);
            return true;
        }
        return false;
    }

    private static PsiElement skipParentheses(PsiElement element, boolean up) {
        if (up) {
            PsiElement parent = element.getParent();
            while (parent instanceof GrParenthesizedExpression) {
                parent = parent.getParent();
            }
            return parent;
        }
        while (element instanceof GrParenthesizedExpression) {
            element = ((GrParenthesizedExpression)element).getOperand();
        }
        return element;
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            return MyPredicate.satisfiedBy(element, true);
        }

        public static boolean satisfiedBy(PsiElement element, boolean checkForParent) {
            PsiElement parent;
            if (!(element instanceof GrBinaryExpression)) {
                return false;
            }
            GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
            if (!GroovyTokenTypes.mPLUS.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            if (checkForParent && (parent = ConvertConcatenationToGstringIntention.skipParentheses(binaryExpression, true)) instanceof GrBinaryExpression && GroovyTokenTypes.mPLUS.equals(((GrBinaryExpression)parent).getOperationTokenType())) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            PsiType type = binaryExpression.getType();
            if (type == null) {
                return false;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            PsiClassType stringType = factory.createTypeByFQClassName("java.lang.String", element.getResolveScope());
            PsiClassType gstringType = factory.createTypeByFQClassName("groovy.lang.GString", element.getResolveScope());
            return TypeConversionUtil.isAssignable((PsiType)stringType, (PsiType)type) || TypeConversionUtil.isAssignable((PsiType)gstringType, (PsiType)type);
        }
    }
}

