/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GradleSetupPanel {
    private JPanel mainPanel;
    private JPanel messagePanel;
    private JLabel messageLabel;
    private String messageDetails;
    private String message;
    private JButton detailsButton;

    public GradleSetupPanel() {
        this.setupUI();
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    private void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(this.createMessageComponent());
        this.mainPanel.add((Component)innerPanel, "North");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private Component createMessageComponent() {
        this.messagePanel = new JPanel();
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 0));
        this.messageLabel = new JLabel();
        this.detailsButton = new JButton(new AbstractAction("Details..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleSetupPanel.this.showDetails();
            }
        });
        this.messagePanel.add(this.messageLabel);
        this.messagePanel.add(Box.createHorizontalStrut(10));
        this.messagePanel.add(this.detailsButton);
        this.messagePanel.setVisible(false);
        return this.messagePanel;
    }

    private void showDetails() {
        JTextArea detailsTextArea = new JTextArea();
        detailsTextArea.setOpaque(true);
        detailsTextArea.setEditable(false);
        detailsTextArea.setBorder(null);
        detailsTextArea.setLineWrap(false);
        detailsTextArea.setWrapStyleWord(true);
        detailsTextArea.setText(this.message + "\n" + this.messageDetails);
        detailsTextArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(detailsTextArea);
        scrollPane.setPreferredSize(new Dimension(400, 500));
        JOptionPane.showMessageDialog(this.mainPanel, scrollPane);
    }

    public void setMessage(String message, String messageDetails) {
        this.messageDetails = messageDetails;
        this.message = message;
        this.messageLabel.setText(message);
        this.detailsButton.setVisible(messageDetails != null);
        this.messagePanel.setVisible(true);
    }

    public void hideMessage() {
        this.messagePanel.setVisible(false);
    }
}

