/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.noReturnMethod;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;

public class MissingReturnInspection
extends GroovySuppressableInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroovyInspectionBundle.message("groovy.dfa.issues", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Groovy", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection.getGroupPath must not return null");
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("no.return.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection.buildVisitor must not be null");
        }
        GroovyPsiElementVisitor groovyPsiElementVisitor = new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitClosure(GrClosableBlock closure) {
                MissingReturnInspection.check(closure, problemsHolder, false);
                super.visitClosure(closure);
            }

            @Override
            public void visitMethod(GrMethod method) {
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    boolean mustReturnValue = method.getReturnTypeElementGroovy() != null && method.getReturnType() != PsiType.VOID;
                    MissingReturnInspection.check(block, problemsHolder, mustReturnValue);
                }
                super.visitMethod(method);
            }
        });
        if (groovyPsiElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection.buildVisitor must not return null");
        }
        return groovyPsiElementVisitor;
    }

    private static void check(GrCodeBlock block, ProblemsHolder holder, boolean mustReturnValue) {
        final Ref always = new Ref((Object)true);
        final Ref hasExplicitReturn = new Ref((Object)false);
        final Ref sometimes = new Ref((Object)false);
        ControlFlowUtils.visitAllExitPoints(block, new ControlFlowUtils.ExitPointVisitor(){

            @Override
            public boolean visit(Instruction instruction) {
                if (instruction instanceof MaybeReturnInstruction) {
                    if (((MaybeReturnInstruction)instruction).mayReturnValue()) {
                        sometimes.set((Object)true);
                    } else {
                        always.set((Object)false);
                    }
                    return true;
                }
                PsiElement element = instruction.getElement();
                if (element instanceof GrReturnStatement) {
                    sometimes.set((Object)true);
                    if (((GrReturnStatement)element).getReturnValue() != null) {
                        hasExplicitReturn.set((Object)true);
                    }
                } else if (element instanceof GrThrowStatement || element instanceof GrAssertStatement) {
                    sometimes.set((Object)true);
                } else {
                    always.set((Object)false);
                }
                return true;
            }
        });
        if (!((Boolean)hasExplicitReturn.get()).booleanValue()) {
            if (!mustReturnValue) {
                return;
            }
            mustReturnValue = true;
        }
        if (mustReturnValue && !((Boolean)sometimes.get()).booleanValue() || ((Boolean)sometimes.get()).booleanValue() && !((Boolean)always.get()).booleanValue()) {
            MissingReturnInspection.addNoReturnMessage(block, holder);
        }
    }

    private static void addNoReturnMessage(GrCodeBlock block, ProblemsHolder holder) {
        PsiElement lastChild = block.getLastChild();
        if (lastChild == null) {
            return;
        }
        TextRange range = lastChild.getTextRange();
        if (!lastChild.isValid() || !lastChild.isPhysical() || range.getStartOffset() >= range.getEndOffset()) {
            return;
        }
        holder.registerProblem(lastChild, GroovyInspectionBundle.message("no.return.message", new Object[0]), new LocalQuickFix[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GroovyMissingReturnStatement" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/noReturnMethod/MissingReturnInspection.getShortName must not return null");
        }
        return "GroovyMissingReturnStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

