/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.clientProperties;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.clientProperties.AddClientPropertyDialog;
import com.intellij.uiDesigner.clientProperties.ClassNameInputDialog;
import com.intellij.uiDesigner.clientProperties.ClientPropertiesManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ConfigureClientPropertiesDialog
extends DialogWrapper {
    private JPanel myRootPanel;
    private JTree myClassTree;
    private JTable myPropertiesTable;
    private JSplitPane mySplitPane;
    private JPanel myClassToolBarPanel;
    private JPanel myPropertyToolBarPanel;
    private Class mySelectedClass;
    private ClientPropertiesManager.ClientProperty[] mySelectedProperties = new ClientPropertiesManager.ClientProperty[0];
    private final MyTableModel myTableModel;
    private final Project myProject;
    private final ClientPropertiesManager myManager;

    public ConfigureClientPropertiesDialog(Project project) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myTableModel = new MyTableModel();
        this.myProject = project;
        this.init();
        this.setTitle(UIDesignerBundle.message("client.properties.title", new Object[0]));
        this.myManager = ClientPropertiesManager.getInstance(project).clone();
        this.myClassTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath leadSelectionPath = e.getNewLeadSelectionPath();
                if (leadSelectionPath == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
                ConfigureClientPropertiesDialog.this.mySelectedClass = (Class)node.getUserObject();
                ConfigureClientPropertiesDialog.this.updateSelectedProperties();
            }
        });
        this.myClassTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Class cls;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof Class && (cls = (Class)node.getUserObject()) != null) {
                    this.append(cls.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        ConfigureClientPropertiesDialog.createToolBar(new AddClassAction(), new RemoveClassAction(), this.myClassToolBarPanel, this.myClassTree);
        ConfigureClientPropertiesDialog.createToolBar(new AddPropertyAction(), new RemovePropertyAction(), this.myPropertyToolBarPanel, this.myPropertiesTable);
        this.myPropertiesTable.setModel(this.myTableModel);
        int location = DimensionService.getInstance().getExtendedState(this.getDimensionKey());
        if (location > 0) {
            this.mySplitPane.setDividerLocation(location);
        }
        this.fillClassTree();
    }

    private static void createToolBar(AnAction addAction, AnAction removeAction, JPanel panel, JComponent shortcutHost) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(addAction);
        group.add(removeAction);
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        panel.add((Component)toolBar.getComponent(), "Center");
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, shortcutHost);
        removeAction.registerCustomShortcutSet(CommonShortcuts.DELETE, shortcutHost);
    }

    public void save() {
        ClientPropertiesManager.getInstance(this.myProject).saveFrom(this.myManager);
    }

    public void dispose() {
        DimensionService.getInstance().setExtendedState(this.getDimensionKey(), this.mySplitPane.getDividerLocation());
        super.dispose();
    }

    private void fillClassTree() {
        List<Class> configuredClasses = this.myManager.getConfiguredClasses();
        Collections.sort(configuredClasses, new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return this.getInheritanceLevel(o1) - this.getInheritanceLevel(o2);
            }

            private int getInheritanceLevel(Class aClass) {
                int level = 0;
                while (aClass.getSuperclass() != null) {
                    ++level;
                    aClass = aClass.getSuperclass();
                }
                return level;
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        HashMap<Class, DefaultMutableTreeNode> classToNodeMap = new HashMap<Class, DefaultMutableTreeNode>();
        for (Class cls : configuredClasses) {
            DefaultMutableTreeNode parentNode = root;
            for (Class superClass = cls.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                if (!classToNodeMap.containsKey(superClass)) continue;
                parentNode = (DefaultMutableTreeNode)classToNodeMap.get(superClass);
                break;
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(cls);
            classToNodeMap.put(cls, childNode);
            parentNode.add(childNode);
        }
        this.myClassTree.setModel(treeModel);
        this.myClassTree.expandRow(0);
        this.myClassTree.getSelectionModel().setSelectionMode(1);
        this.myClassTree.getSelectionModel().setSelectionPath(new TreePath(new Object[]{root, root.getFirstChild()}));
    }

    private void updateSelectedProperties() {
        this.mySelectedProperties = this.myManager.getConfiguredProperties(this.mySelectedClass);
        this.myTableModel.fireTableDataChanged();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "ConfigureClientPropertiesDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTable jTable;
        JPanel jPanel2;
        JTree jTree;
        JSplitPane jSplitPane;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(400, 200), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel4);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(150, 200), null));
        this.myClassTree = jTree = new JTree();
        jTree.setRootVisible(false);
        jScrollPane.setViewportView(jTree);
        this.myClassToolBarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel5);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel5.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myPropertiesTable = jTable = new JTable();
        jScrollPane2.setViewportView(jTable);
        this.myPropertyToolBarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class RemovePropertyAction
    extends AnAction {
        public RemovePropertyAction() {
            super(UIDesignerBundle.message("client.properties.remove.property.tooltip", new Object[0]), "", IconLoader.getIcon((String)"/general/remove.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            int row = ConfigureClientPropertiesDialog.this.myPropertiesTable.getSelectedRow();
            if (row >= 0 && row < ConfigureClientPropertiesDialog.this.mySelectedProperties.length) {
                ConfigureClientPropertiesDialog.this.myManager.removeConfiguredProperty(ConfigureClientPropertiesDialog.this.mySelectedClass, ConfigureClientPropertiesDialog.this.mySelectedProperties[row].getName());
                ConfigureClientPropertiesDialog.this.updateSelectedProperties();
                if (ConfigureClientPropertiesDialog.this.mySelectedProperties.length > 0) {
                    if (row >= ConfigureClientPropertiesDialog.this.mySelectedProperties.length) {
                        --row;
                    }
                    ConfigureClientPropertiesDialog.this.myPropertiesTable.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ConfigureClientPropertiesDialog.this.myPropertiesTable.getSelectedRow() >= 0);
        }
    }

    private class AddPropertyAction
    extends AnAction {
        public AddPropertyAction() {
            super(UIDesignerBundle.message("client.properties.add.property.tooltip", new Object[0]), "", IconLoader.getIcon((String)"/general/add.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            AddClientPropertyDialog dlg = new AddClientPropertyDialog(ConfigureClientPropertiesDialog.this.myProject);
            dlg.show();
            if (dlg.getExitCode() == 0) {
                ClientPropertiesManager.ClientProperty[] props;
                for (ClientPropertiesManager.ClientProperty prop : props = ConfigureClientPropertiesDialog.this.myManager.getClientProperties(ConfigureClientPropertiesDialog.this.mySelectedClass)) {
                    if (!prop.getName().equalsIgnoreCase(dlg.getEnteredProperty().getName())) continue;
                    Messages.showErrorDialog((Component)ConfigureClientPropertiesDialog.this.myRootPanel, (String)UIDesignerBundle.message("client.properties.already.defined", prop.getName()), (String)UIDesignerBundle.message("client.properties.title", new Object[0]));
                    return;
                }
                ConfigureClientPropertiesDialog.this.myManager.addConfiguredProperty(ConfigureClientPropertiesDialog.this.mySelectedClass, dlg.getEnteredProperty());
                ConfigureClientPropertiesDialog.this.updateSelectedProperties();
            }
        }
    }

    private class RemoveClassAction
    extends AnAction {
        public RemoveClassAction() {
            super(UIDesignerBundle.message("client.properties.remove.class.tooltip", new Object[0]), "", IconLoader.getIcon((String)"/general/remove.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            if (ConfigureClientPropertiesDialog.this.mySelectedClass != null) {
                ConfigureClientPropertiesDialog.this.myManager.removeClientPropertyClass(ConfigureClientPropertiesDialog.this.mySelectedClass);
                ConfigureClientPropertiesDialog.this.fillClassTree();
            }
        }
    }

    private class AddClassAction
    extends AnAction {
        public AddClassAction() {
            super(UIDesignerBundle.message("client.properties.add.class.tooltip", new Object[0]), "", IconLoader.getIcon((String)"/general/add.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ClassNameInputDialog dlg = new ClassNameInputDialog(ConfigureClientPropertiesDialog.this.myProject, ConfigureClientPropertiesDialog.this.myRootPanel);
            dlg.show();
            if (dlg.getExitCode() == 0) {
                Class<?> aClass;
                String className = dlg.getClassName();
                if (className.length() == 0) {
                    return;
                }
                try {
                    aClass = Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    Messages.showErrorDialog((Component)ConfigureClientPropertiesDialog.this.myRootPanel, (String)UIDesignerBundle.message("client.properties.class.not.found", className), (String)UIDesignerBundle.message("client.properties.title", new Object[0]));
                    return;
                }
                if (!JComponent.class.isAssignableFrom(aClass)) {
                    Messages.showErrorDialog((Component)ConfigureClientPropertiesDialog.this.myRootPanel, (String)UIDesignerBundle.message("client.properties.class.not.component", className), (String)UIDesignerBundle.message("client.properties.title", new Object[0]));
                    return;
                }
                ConfigureClientPropertiesDialog.this.myManager.addClientPropertyClass(className);
                ConfigureClientPropertiesDialog.this.fillClassTree();
            }
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return ConfigureClientPropertiesDialog.this.mySelectedProperties.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ConfigureClientPropertiesDialog.this.mySelectedProperties[rowIndex].getName();
                }
            }
            return ConfigureClientPropertiesDialog.this.mySelectedProperties[rowIndex].getValueClass();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return UIDesignerBundle.message("client.properties.name", new Object[0]);
                }
            }
            return UIDesignerBundle.message("client.properties.class", new Object[0]);
        }
    }
}

