/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertIntegerToOctalPredicate
implements PsiElementPredicate {
    ConvertIntegerToOctalPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        PsiType type = expression.getType();
        if (!PsiType.INT.equals(type) && !PsiType.LONG.equals(type)) {
            return false;
        }
        String text = expression.getText();
        if (text == null || text.length() == 0) {
            return false;
        }
        if (text.startsWith("0x") || text.startsWith("0X")) {
            return true;
        }
        if ("0".equals(text) || "0L".equals(text)) {
            return false;
        }
        return text.charAt(0) != '0';
    }
}

