/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipConjunctionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        return IntentionPowerPackBundle.message("flip.smth.intention.name", sign.getText());
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/bool/FlipConjunctionIntention.getElementPredicate must not return null");
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiExpression exp = (PsiExpression)element;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)exp;
        assert (binaryExpression != null);
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType conjunctionType = sign.getTokenType();
        PsiElement parent = exp.getParent();
        while (FlipConjunctionIntention.isConjunctionExpression(parent, conjunctionType)) {
            exp = (PsiExpression)parent;
            assert (exp != null);
            parent = exp.getParent();
        }
        String newExpression = FlipConjunctionIntention.flipExpression(exp, conjunctionType);
        FlipConjunctionIntention.replaceExpression(newExpression, exp);
    }

    private static String flipExpression(PsiExpression expression, IElementType conjunctionType) {
        if (FlipConjunctionIntention.isConjunctionExpression((PsiElement)expression, conjunctionType)) {
            PsiBinaryExpression andExpression = (PsiBinaryExpression)expression;
            PsiExpression rhs = andExpression.getROperand();
            PsiExpression lhs = andExpression.getLOperand();
            String conjunctionSign = conjunctionType.equals(JavaTokenType.ANDAND) ? "&&" : "||";
            return FlipConjunctionIntention.flipExpression(rhs, conjunctionType) + ' ' + conjunctionSign + ' ' + FlipConjunctionIntention.flipExpression(lhs, conjunctionType);
        }
        return expression.getText();
    }

    private static boolean isConjunctionExpression(PsiElement element, IElementType conjunctionType) {
        if (!(element instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        return tokenType.equals(conjunctionType);
    }
}

