/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyFoldingBuilder
extends FoldingBuilderEx {
    private static final int FOLD_MAX_LENGTH = 50;
    private static final Key<Property> CACHE = Key.create((String)"i18n.property.cache");
    public static final Property NULL = new PropertyImpl((PropertyStub)new PropertyStubImpl(null, null), PropertiesElementTypes.PROPERTY);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element, @NotNull Document document, boolean quick) {
        FoldingDescriptor[] foldingDescriptorArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder.buildFoldRegions must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder.buildFoldRegions must not be null");
        }
        if (!(element instanceof PsiJavaFile) || quick || !PropertyFoldingBuilder.isFoldingsOn()) {
            foldingDescriptorArray = FoldingDescriptor.EMPTY;
            if (FoldingDescriptor.EMPTY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder.buildFoldRegions must not return null");
            return foldingDescriptorArray;
        }
        PsiJavaFile file = (PsiJavaFile)element;
        final ArrayList result = new ArrayList();
        boolean hasJsp = ContainerUtil.intersects(Arrays.asList(StdLanguages.JSP, StdLanguages.JSPX), (Collection)file.getViewProvider().getLanguages());
        file.accept((PsiElementVisitor)(hasJsp ? new JavaRecursiveElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PropertyFoldingBuilder.checkLiteral(expression, result);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PropertyFoldingBuilder.checkLiteral(expression, result);
            }
        }));
        foldingDescriptorArray = result.toArray(new FoldingDescriptor[result.size()]);
        if (foldingDescriptorArray != null) return foldingDescriptorArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder.buildFoldRegions must not return null");
    }

    private static boolean isFoldingsOn() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    private static void checkLiteral(PsiLiteralExpression expression, List<FoldingDescriptor> result) {
        if (PropertyFoldingBuilder.isI18nProperty(expression)) {
            Property property = PropertyFoldingBuilder.getI18nProperty(expression);
            HashSet<Property> set = new HashSet<Property>();
            set.add(property);
            String msg = PropertyFoldingBuilder.formatI18nProperty(expression, property);
            PsiElement parent = expression.getParent();
            if (!msg.equals(expression.getText()) && parent instanceof PsiExpressionList && ((PsiExpressionList)parent).getExpressions()[0] == expression) {
                PsiExpressionList expressions = (PsiExpressionList)parent;
                int count = JavaI18nUtil.getPropertyValueParamsMaxCount(expression);
                PsiExpression[] args = expressions.getExpressions();
                if (args.length == 1 + count && parent.getParent() instanceof PsiMethodCallExpression) {
                    boolean ok = true;
                    for (int i = 1; i < count + 1; ++i) {
                        Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)args[i], (boolean)false);
                        if (value != null || args[i] instanceof PsiReferenceExpression) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        result.add(new FoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)parent.getParent().getNode()), parent.getParent().getTextRange(), null, set));
                        return;
                    }
                }
            }
            result.add(new FoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)expression.getNode()), expression.getTextRange(), null, set));
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder.getPlaceholderText must not be null");
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (element instanceof PsiLiteralExpression) {
            return PropertyFoldingBuilder.getI18nMessage((PsiLiteralExpression)element);
        }
        if (element instanceof PsiMethodCallExpression) {
            return PropertyFoldingBuilder.formatMethodCallExpression((PsiMethodCallExpression)element);
        }
        return element.getText();
    }

    private static String formatMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
        int count;
        PsiExpression[] args = methodCallExpression.getArgumentList().getExpressions();
        if (args.length > 0 && args[0] instanceof PsiLiteralExpression && PropertyFoldingBuilder.isI18nProperty((PsiLiteralExpression)args[0]) && args.length == 1 + (count = JavaI18nUtil.getPropertyValueParamsMaxCount((PsiLiteralExpression)args[0]))) {
            String text = PropertyFoldingBuilder.getI18nMessage((PsiLiteralExpression)args[0]);
            for (int i = 1; i < count + 1; ++i) {
                Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)args[i], (boolean)false);
                if (value == null) {
                    if (args[i] instanceof PsiReferenceExpression) {
                        value = "{" + args[i].getText() + "}";
                    } else {
                        text = null;
                        break;
                    }
                }
                text = text.replace("{" + (i - 1) + "}", value.toString());
            }
            if (text != null) {
                if (!text.equals(methodCallExpression.getText())) {
                    text = text.replace("''", "'");
                }
                return text.length() > 50 ? text.substring(0, 47) + "...\"" : text;
            }
        }
        return methodCallExpression.getText();
    }

    private static String getI18nMessage(PsiLiteralExpression literal) {
        Property property = PropertyFoldingBuilder.getI18nProperty(literal);
        return property == null ? literal.getText() : PropertyFoldingBuilder.formatI18nProperty(literal, property);
    }

    @Nullable
    private static Property getI18nProperty(PsiLiteralExpression literal) {
        Property property = (Property)literal.getUserData(CACHE);
        if (property == NULL) {
            return null;
        }
        if (property != null && property.isValid()) {
            return property;
        }
        if (PropertyFoldingBuilder.isI18nProperty(literal)) {
            PsiReference[] references;
            for (PsiReference reference : references = literal.getReferences()) {
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof Property)) continue;
                        Property p = (Property)element;
                        literal.putUserData(CACHE, (Object)p);
                        return p;
                    }
                    continue;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof Property)) continue;
                Property p = (Property)element;
                literal.putUserData(CACHE, (Object)p);
                return p;
            }
        }
        return null;
    }

    private static String formatI18nProperty(PsiLiteralExpression literal, Property property) {
        return property == null ? literal.getText() : "\"" + property.getValue() + "\"";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder.isCollapsedByDefault must not be null");
        }
        return PropertyFoldingBuilder.isFoldingsOn();
    }

    public static boolean isI18nProperty(PsiLiteralExpression expr) {
        if (!PropertyFoldingBuilder.isStringLiteral(expr)) {
            return false;
        }
        Property property = (Property)expr.getUserData(CACHE);
        if (property == NULL) {
            return false;
        }
        if (property != null) {
            return true;
        }
        HashMap<String, Object> annotationParams = new HashMap<String, Object>();
        annotationParams.put("resourceBundle", null);
        boolean isI18n = JavaI18nUtil.mustBePropertyKey(expr, annotationParams);
        if (!isI18n) {
            expr.putUserData(CACHE, (Object)NULL);
        }
        return isI18n;
    }

    private static boolean isStringLiteral(PsiLiteralExpression expr) {
        String text;
        if (expr == null || (text = expr.getText()) == null) {
            return false;
        }
        return text.startsWith("\"") && text.endsWith("\"") && text.length() > 2;
    }
}

