/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.testframework.Filter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Arrays;

public class StatisticsTable
extends ListTableModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.StatisticsTable");
    private TestProxy myTest;
    private JUnitRunningModel myModel;

    public StatisticsTable(ColumnInfo[] collumnNames) {
        super(collumnNames);
    }

    public void setModel(JUnitRunningModel model) {
        this.myModel = model;
        this.setTest(this.myModel.getRoot());
    }

    public void onSelectionChanged(TestProxy test) {
        this.setTest(test);
    }

    private void setTest(TestProxy test) {
        if (this.myTest == test) {
            return;
        }
        this.updateStatistics(test);
    }

    private void changeTableData() {
        if (this.myTest == null) {
            this.resetTests();
            return;
        }
        this.setItems(new ArrayList<TestProxy>(Arrays.asList(this.myTest.selectChildren(Filter.NO_FILTER))));
    }

    private void resetTests() {
        this.setItems(new ArrayList());
    }

    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            return this.testProperty(columnIndex);
        }
        return super.getValueAt(rowIndex - 1, columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LOG.error("value: " + aValue + " row: " + rowIndex + " column: " + columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    private Object testProperty(int columnIndex) {
        if (columnIndex == 0) {
            return ExecutionBundle.message((String)"junit.runing.info.total.label", (Object[])new Object[0]);
        }
        return this.getAspectOf(columnIndex, (Object)this.myTest);
    }

    public TestProxy getTestAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.getItems().size()) {
            return null;
        }
        return rowIndex == 0 ? this.myTest : (TestProxy)((Object)this.getItems().get(rowIndex - 1));
    }

    public int getIndexOf(Object test) {
        if (test == this.myTest) {
            return 0;
        }
        for (int i = 0; i < this.getItems().size(); ++i) {
            Object child = this.getItems().get(i);
            if (child != test) continue;
            return i + 1;
        }
        return -1;
    }

    public void updateStatistics(TestProxy currentTest) {
        this.myTest = currentTest;
        this.changeTableData();
    }
}

