/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleCheckedLockingInspection
extends BaseInspection {
    public boolean ignoreOnVolatileVariables = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.checked.locking.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/DoubleCheckedLockingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.checked.locking.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/DoubleCheckedLockingInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("double.checked.locking.ignore.on.volatiles.option", new Object[0]), (InspectionProfileEntry)this, "ignoreOnVolatileVariables");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleCheckedLockingVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos == null || infos.length == 0 || infos[0] == null) {
            return null;
        }
        PsiField field = (PsiField)infos[0];
        final IntentionAction action = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)field, "volatile", true, true);
        return new InspectionGadgetsFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                if (action.isAvailable(project, null, null)) {
                    action.invoke(project, null, null);
                }
            }

            @NotNull
            public String getName() {
                String string = action.getText();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/DoubleCheckedLockingInspection$1.getName must not return null");
                }
                return string;
            }
        };
    }

    private class DoubleCheckedLockingVisitor
    extends BaseInspectionVisitor {
        private DoubleCheckedLockingVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/DoubleCheckedLockingInspection$DoubleCheckedLockingVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            PsiExpression outerCondition = statement.getCondition();
            if (outerCondition == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(outerCondition)) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement syncStatement = (PsiSynchronizedStatement)thenBranch;
            PsiCodeBlock body = syncStatement.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return;
            }
            if (!(statements[0] instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement innerIf = (PsiIfStatement)statements[0];
            PsiExpression innerCondition = innerIf.getCondition();
            if (!EquivalenceChecker.expressionsAreEquivalent(innerCondition, outerCondition)) {
                return;
            }
            PsiField field = null;
            if (DoubleCheckedLockingInspection.this.ignoreOnVolatileVariables && (field = this.findCheckedField(innerIf)) != null && field.hasModifierProperty("volatile")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, field);
        }

        @Nullable
        private PsiField findCheckedField(PsiIfStatement statement) {
            PsiBinaryExpression binaryExpression;
            PsiExpression expression = statement.getCondition();
            if (expression instanceof PsiBinaryExpression && (binaryExpression = (PsiBinaryExpression)expression).getOperationTokenType() == JavaTokenType.EQEQ) {
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                PsiExpression fieldReference = null;
                if (PsiType.NULL.equals(lOperand.getType())) {
                    fieldReference = rOperand;
                } else if (rOperand != null && PsiType.NULL.equals(rOperand.getType())) {
                    fieldReference = lOperand;
                }
                if (fieldReference instanceof PsiReferenceExpression) {
                    PsiElement resolved = ((PsiReferenceExpression)fieldReference).resolve();
                    return resolved instanceof PsiField ? (PsiField)resolved : null;
                }
            }
            return null;
        }
    }
}

