/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class ChannelResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        if ("ChannelOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/ChannelResourceInspection.getID must not return null");
        }
        return "ChannelOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("channel.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/ChannelResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("channel.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/ChannelResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChannelResourceVisitor();
    }

    private static class ChannelResourceVisitor
    extends BaseInspectionVisitor {
        private ChannelResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/ChannelResourceInspection$ChannelResourceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!ChannelResourceVisitor.isChannelFactoryMethod(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ChannelResourceVisitor.isChannelFactoryClosedInFinally(expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isChannelFactoryClosedInFinally(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
            if (tryStatement == null) {
                return false;
            }
            while (!ResourceInspection.resourceIsClosedInFinally(tryStatement, variable)) {
                if ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class})) != null) continue;
                return false;
            }
            return true;
        }

        private static boolean isChannelFactoryMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getChannel".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.net.Socket", "java.net.DatagramSocket", "java.net.ServerSocket", "java.io.FileInputStream", "java.io.FileOutputStream", "java.io.RandomAccessFile", "com.sun.corba.se.pept.transport.EventHandler", "sun.nio.ch.InheritedChannel") != null;
        }
    }
}

