/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import org.jetbrains.annotations.NotNull;

public class UtilityClassUtil {
    private UtilityClassUtil() {
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/UtilityClassUtil.isUtilityClass must not be null");
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList != null && extendsList.getReferenceElements().length > 0) {
            return false;
        }
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList != null && implementsList.getReferenceElements().length > 0) {
            return false;
        }
        PsiMethod[] methods = aClass.getMethods();
        int staticMethodCount = UtilityClassUtil.countStaticMethods(methods);
        if (staticMethodCount < 0) {
            return false;
        }
        PsiField[] fields = aClass.getFields();
        if (!UtilityClassUtil.allFieldsStatic(fields)) {
            return false;
        }
        return staticMethodCount != 0 || fields.length != 0;
    }

    private static boolean allFieldsStatic(PsiField[] fields) {
        for (PsiField field : fields) {
            if (field.hasModifierProperty("static")) continue;
            return false;
        }
        return true;
    }

    private static int countStaticMethods(PsiMethod[] methods) {
        int staticCount = 0;
        for (PsiMethod method : methods) {
            if (method.isConstructor()) continue;
            if (!method.hasModifierProperty("static")) {
                return -1;
            }
            if (method.hasModifierProperty("private")) continue;
            ++staticCount;
        }
        return staticCount;
    }
}

