/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class ParameterNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;

    @NotNull
    public String getID() {
        if ("MethodParameterNamingConvention" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNamingConventionInspection.getID must not return null");
        }
        return "MethodParameterNamingConvention";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String parametername = (String)infos[0];
        if (parametername.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("parameter.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (parametername.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("parameter.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("parameter.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/ParameterNamingConventionInspection$NamingConventionsVisitor.visitParameter must not be null");
            }
            PsiElement scope = variable.getDeclarationScope();
            if (scope instanceof PsiCatchSection || scope instanceof PsiForeachStatement) {
                return;
            }
            String name = variable.getName();
            if (name == null || ParameterNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name);
        }
    }
}

