/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.name.same.as.class.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNameSameAsClassNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.name.same.as.class.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNameSameAsClassNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        Boolean onTheFly = (Boolean)infos[0];
        if (onTheFly.booleanValue()) {
            inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix(), new MethodNameSameAsClassNameFix()};
            if (inspectionGadgetsFixArray == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNameSameAsClassNameInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MethodNameSameAsClassNameFix()};
        if (inspectionGadgetsFixArray != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNameSameAsClassNameInspection.buildFixes must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNameSameAsClassNameVisitor();
    }

    private static class MethodNameSameAsClassNameVisitor
    extends BaseInspectionVisitor {
        private MethodNameSameAsClassNameVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/MethodNameSameAsClassNameInspection$MethodNameSameAsClassNameVisitor.visitMethod must not be null");
            }
            if (method.isConstructor()) {
                return;
            }
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getName();
            if (className == null) {
                return;
            }
            if (!methodName.equals(className)) {
                return;
            }
            this.registerMethodError(method, this.isOnTheFly());
        }
    }

    private static class MethodNameSameAsClassNameFix
    extends InspectionGadgetsFix {
        private MethodNameSameAsClassNameFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.method.ctr.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNameSameAsClassNameInspection$MethodNameSameAsClassNameFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            returnTypeElement.delete();
        }
    }
}

