/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveClassFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ClassInTopLevelPackageInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassWithoutPackageStatement" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassInTopLevelPackageInspection.getID must not return null");
        }
        return "ClassWithoutPackageStatement";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.in.top.level.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassInTopLevelPackageInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.in.top.level.package.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassInTopLevelPackageInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveClassFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInTopLevelPackageVisitor();
    }

    private static class ClassInTopLevelPackageVisitor
    extends BaseInspectionVisitor {
        private ClassInTopLevelPackageVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/ClassInTopLevelPackageInspection$ClassInTopLevelPackageVisitor.visitClass must not be null");
            }
            if (JspPsiUtil.isInJspFile((PsiElement)aClass)) {
                return;
            }
            if (ClassUtils.isInnerClass(aClass)) {
                return;
            }
            PsiFile file = aClass.getContainingFile();
            if (file == null || !(file instanceof PsiJavaFile)) {
                return;
            }
            if (((PsiJavaFile)file).getPackageStatement() != null) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

