/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class FieldView
extends PlainView {
    BoundedRangeModel horizontalVisibility;
    float cachedSpan;

    private /* synthetic */ void finit$() {
        this.cachedSpan = -1.0f;
    }

    public FieldView(Element element) {
        super(element);
        this.finit$();
    }

    private void checkContainer() {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            this.horizontalVisibility = ((JTextField)container).getHorizontalVisibility();
            this.horizontalVisibility.addChangeListener(new ChangeListener(this){
                private /* synthetic */ FieldView this$0;
                {
                    this.this$0 = fieldView;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$0.getContainer().repaint();
                }
            });
            this.calculateHorizontalSpan();
            this.updateVisibility();
        }
    }

    private void updateVisibility() {
        JTextField jTextField = (JTextField)this.getContainer();
        Insets insets = jTextField.getInsets();
        int n = jTextField.getWidth() - insets.left - insets.right;
        this.horizontalVisibility.setMaximum(Math.max(this.cachedSpan != -1.0f ? (int)this.cachedSpan : (int)this.calculateHorizontalSpan(), n));
        this.horizontalVisibility.setExtent(n - 1);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    protected Shape adjustAllocation(Shape shape) {
        int n;
        int n2;
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape.getBounds();
        int n3 = (int)this.getPreferredSpan(1);
        int n4 = rectangle.y + (rectangle.height - n3) / 2;
        JTextField jTextField = (JTextField)this.getContainer();
        int n5 = n2 = this.cachedSpan != -1.0f ? (int)this.cachedSpan : (int)this.calculateHorizontalSpan();
        if (this.horizontalVisibility != null && this.horizontalVisibility.getExtent() < n2) {
            n = rectangle.x - this.horizontalVisibility.getValue();
        } else {
            switch (jTextField.getHorizontalAlignment()) {
                case 0: {
                    n = rectangle.x + (rectangle.width - n2) / 2;
                    break;
                }
                case 4: {
                    n = rectangle.x + (rectangle.width - n2 - 1);
                    break;
                }
                case 11: {
                    if (jTextField.getComponentOrientation().isLeftToRight()) {
                        n = rectangle.x + (rectangle.width - n2 - 1);
                        break;
                    }
                    n = rectangle.x;
                    break;
                }
                case 10: {
                    if (jTextField.getComponentOrientation().isLeftToRight()) {
                        n = rectangle.x;
                        break;
                    }
                    n = rectangle.x + (rectangle.width - n2 - 1);
                    break;
                }
                default: {
                    n = rectangle.x;
                }
            }
        }
        return new Rectangle(n, n4, n2, n3);
    }

    public float getPreferredSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (n == 1) {
            return super.getPreferredSpan(n);
        }
        if (this.cachedSpan != -1.0f) {
            return this.cachedSpan;
        }
        return this.calculateHorizontalSpan();
    }

    private float calculateHorizontalSpan() {
        Segment segment = this.getLineBuffer();
        Element element = this.getElement();
        try {
            element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - 1, segment);
            this.cachedSpan = Utilities.getTabbedTextWidth(segment, this.getFontMetrics(), 0, this, segment.offset);
            return this.cachedSpan;
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError();
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    public int getResizeWeight(int n) {
        n = n == 0 ? 1 : 0;
        return n;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        return super.modelToView(n, shape2, bias);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.horizontalVisibility == null) {
            this.checkContainer();
        }
        Shape shape2 = this.adjustAllocation(shape);
        Shape shape3 = graphics.getClip();
        if (shape3 != null) {
            Rectangle rectangle = shape.getBounds();
            Rectangle rectangle2 = shape3.getBounds();
            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
            graphics.setClip(rectangle2);
        } else {
            graphics.setClip(shape);
        }
        super.paint(graphics, shape2);
        graphics.setClip(shape3);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.cachedSpan = -1.0f;
        if (this.horizontalVisibility != null) {
            this.updateVisibility();
        }
        Shape shape2 = this.adjustAllocation(shape);
        super.insertUpdate(documentEvent, shape2, viewFactory);
        this.getContainer().repaint();
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.cachedSpan = -1.0f;
        if (this.horizontalVisibility != null) {
            this.updateVisibility();
        }
        Shape shape2 = this.adjustAllocation(shape);
        super.removeUpdate(documentEvent, shape2, viewFactory);
        this.getContainer().repaint();
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.cachedSpan = -1.0f;
        if (this.horizontalVisibility != null) {
            this.updateVisibility();
        }
        Shape shape2 = this.adjustAllocation(shape);
        super.changedUpdate(documentEvent, shape2, viewFactory);
        this.getContainer().repaint();
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, this.adjustAllocation(shape), biasArray);
    }
}

