/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.basic.BasicIconFactory;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected static final String CLOSE_CMD = "Close";
    protected static final String ICONIFY_CMD = "Minimize";
    protected static final String MAXIMIZE_CMD = "Maximize";
    protected static final String MOVE_CMD = "Move";
    protected static final String RESTORE_CMD = "Restore";
    protected static final String SIZE_CMD = "Size";
    protected Action closeAction;
    protected Action iconifyAction;
    protected Action maximizeAction;
    protected Action moveAction;
    protected Action restoreAction;
    protected Action sizeAction;
    protected JButton closeButton;
    protected JButton iconButton;
    protected JButton maxButton;
    protected Icon minIcon;
    protected Icon maxIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected JInternalFrame frame;
    protected JMenuBar menuBar;
    protected JMenu windowMenu;
    protected Color notSelectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color selectedTextColor;
    protected Color selectedTitleColor;
    protected PropertyChangeListener propertyChangeListener;
    transient JLabel title;

    private /* synthetic */ void finit$() {
        this.minIcon = BasicIconFactory.createEmptyFrameIcon();
        this.maxIcon = BasicIconFactory.createEmptyFrameIcon();
        this.iconIcon = BasicIconFactory.createEmptyFrameIcon();
    }

    public BasicInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.finit$();
        this.frame = jInternalFrame;
        this.setLayout(this.createLayout());
        this.title = new JLabel();
        this.title.setHorizontalAlignment(2);
        this.title.setHorizontalTextPosition(2);
        this.title.setOpaque(false);
        this.setOpaque(true);
        this.setBackground(Color.LIGHT_GRAY);
        this.setOpaque(true);
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.assembleSystemMenu();
        this.createButtons();
        this.setButtonIcons();
        this.addSubComponents();
        this.enableActions();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.closeButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
    }

    protected void createActions() {
        this.closeAction = new CloseAction(this);
        this.closeAction.putValue("ActionCommandKey", CLOSE_CMD);
        this.iconifyAction = new IconifyAction(this);
        this.iconifyAction.putValue("ActionCommandKey", ICONIFY_CMD);
        this.maximizeAction = new MaximizeAction(this);
        this.maximizeAction.putValue("ActionCommandKey", MAXIMIZE_CMD);
        this.sizeAction = new SizeAction(this);
        this.sizeAction.putValue("ActionCommandKey", SIZE_CMD);
        this.restoreAction = new RestoreAction(this);
        this.restoreAction.putValue("ActionCommandKey", RESTORE_CMD);
        this.moveAction = new MoveAction(this);
        this.moveAction.putValue("ActionCommandKey", MOVE_CMD);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults() {
        this.title.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
    }

    protected void uninstallDefaults() {
        this.setFont(null);
        this.selectedTextColor = null;
        this.selectedTitleColor = null;
        this.notSelectedTextColor = null;
        this.notSelectedTitleColor = null;
        this.closeIcon = null;
        this.iconIcon = null;
        this.maxIcon = null;
    }

    protected void createButtons() {
        this.closeButton = new PaneButton(this, this.closeAction);
        this.closeButton.setText(null);
        if (!this.frame.isClosable()) {
            this.closeButton.setVisible(false);
        }
        this.iconButton = new PaneButton(this, this.iconifyAction);
        this.iconButton.setText(null);
        if (!this.frame.isIconifiable()) {
            this.iconButton.setVisible(false);
        }
        this.maxButton = new PaneButton(this, this.maximizeAction);
        this.maxButton.setText(null);
        if (!this.frame.isMaximizable()) {
            this.maxButton.setVisible(false);
        }
    }

    protected void setButtonIcons() {
        if (this.closeIcon != null && this.closeButton != null) {
            this.closeButton.setIcon(this.closeIcon);
        }
        if (this.iconIcon != null && this.iconButton != null) {
            this.iconButton.setIcon(this.iconIcon);
        }
        if (this.maxIcon != null && this.maxButton != null) {
            this.maxButton.setIcon(this.maxIcon);
        }
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(RESTORE_CMD);
        jMenuItem.addActionListener(this.restoreAction);
        jMenuItem.setMnemonic(82);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(MOVE_CMD);
        jMenuItem.addActionListener(this.moveAction);
        jMenuItem.setMnemonic(77);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(SIZE_CMD);
        jMenuItem.addActionListener(this.sizeAction);
        jMenuItem.setMnemonic(83);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(ICONIFY_CMD);
        jMenuItem.addActionListener(this.iconifyAction);
        jMenuItem.setMnemonic(78);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(MAXIMIZE_CMD);
        jMenuItem.addActionListener(this.maximizeAction);
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(CLOSE_CMD);
        jMenuItem.addActionListener(this.closeAction);
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
    }

    protected JMenuBar createSystemMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new SystemMenuBar(this);
        }
        this.menuBar.removeAll();
        return this.menuBar;
    }

    protected JMenu createSystemMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu();
        }
        this.windowMenu.removeAll();
        return this.windowMenu;
    }

    protected void showSystemMenu() {
        this.menuBar.getMenu(1).getPopupMenu().show();
    }

    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
        if (this.frame.getTitle() != null && this.title != null) {
            Color color = graphics.getColor();
            Font font = this.title.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            if (this.frame.isSelected()) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            this.title.setText(this.getTitle(this.frame.getTitle(), fontMetrics, this.title.getBounds().width));
            SwingUtilities.paintComponent(graphics, this.title, null, this.title.getBounds());
            graphics.setColor(color);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        if (!this.isOpaque()) {
            return;
        }
        Color color = graphics.getColor();
        Dimension dimension = this.getSize();
        Color color2 = this.getBackground();
        color2 = this.frame.isSelected() ? this.selectedTitleColor : this.notSelectedTitleColor;
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(color);
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n) {
        Rectangle rectangle = new Rectangle(0, 0, n, fontMetrics.getHeight());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        String string2 = SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, null, 0, 2, 0, 2, rectangle, rectangle2, rectangle3, 0);
        return string2;
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
    }

    protected void enableActions() {
        this.closeAction.setEnabled(this.frame.isClosable());
        this.iconifyAction.setEnabled(this.frame.isIconifiable());
        this.maximizeAction.setEnabled(this.frame.isMaximizable());
        this.restoreAction.setEnabled(this.frame.isMaximum());
        this.sizeAction.setEnabled(this.frame.isResizable());
        this.moveAction.setEnabled(false);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout(this);
    }

    private class PaneButton
    extends JButton {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public PaneButton(BasicInternalFrameTitlePane basicInternalFrameTitlePane, Action action) {
            this.this$0 = basicInternalFrameTitlePane;
            super(action);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public boolean isFocusable() {
            return false;
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public TitlePaneLayout(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n2 = dimension.width - insets.left - insets.right;
            int n3 = dimension.height - insets.top - insets.bottom;
            Dimension dimension2 = this.this$0.menuBar.getPreferredSize();
            this.this$0.menuBar.setBounds(insets.left, insets.top, dimension2.width, n3);
            int n4 = n2 + insets.left - 1;
            int n5 = insets.top + 1;
            int n6 = n3 - 4;
            if (this.this$0.closeButton.isVisible()) {
                n = this.this$0.closeIcon.getIconWidth();
                this.this$0.closeButton.setBounds(n4 -= n + 2, n5, n, n6);
            }
            if (this.this$0.maxButton.isVisible()) {
                n = this.this$0.maxIcon.getIconWidth();
                this.this$0.maxButton.setBounds(n4 -= n + 2, n5, n, n6);
            }
            if (this.this$0.iconButton.isVisible()) {
                n = this.this$0.iconIcon.getIconWidth();
                this.this$0.iconButton.setBounds(n4 -= n + 2, n5, n, n6);
            }
            if (this.this$0.title != null) {
                this.this$0.title.setBounds(insets.left + dimension2.width, insets.top, n4 - dimension2.width - insets.left, n3);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(22, 18);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public boolean isFocusTraversable() {
            return true;
        }

        public boolean isOpaque() {
            return true;
        }

        public void paint(Graphics graphics) {
            Icon icon = this.this$0.frame.getFrameIcon();
            if (icon == null) {
                icon = BasicDesktopIconUI.defaultIcon;
            }
            icon.paintIcon(this, graphics, 0, 0);
        }

        public void requestFocus() {
            super.requestFocus();
        }

        public SystemMenuBar(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("closable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.this$0.closeButton.setVisible(true);
                } else {
                    this.this$0.closeButton.setVisible(false);
                }
            } else if (string.equals("iconable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.this$0.iconButton.setVisible(true);
                } else {
                    this.this$0.iconButton.setVisible(false);
                }
            } else if (string.equals("maximizable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.this$0.maxButton.setVisible(true);
                } else {
                    this.this$0.maxButton.setVisible(false);
                }
            }
            this.this$0.enableActions();
        }

        public PropertyChangeHandler(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
        }
    }

    public class SizeAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public SizeAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
            super("Size");
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class RestoreAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public RestoreAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
            super("Restore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isMaximum()) {
                try {
                    this.this$0.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class MoveAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public MoveAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
            super("Move");
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public MaximizeAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
            super("Maximize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.this$0.frame.isMaximizable() && !this.this$0.frame.isMaximum()) {
                    this.this$0.frame.setMaximum(true);
                } else if (this.this$0.frame.isMaximum()) {
                    this.this$0.frame.setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public IconifyAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
            super("Minimize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isIconifiable() && !this.this$0.frame.isIcon()) {
                try {
                    this.this$0.frame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public CloseAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
            this.this$0 = basicInternalFrameTitlePane;
            super("Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.frame.isClosable()) {
                try {
                    this.this$0.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

