/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private static final String SERVICE = "SecretKeyFactory";
    private SecretKeyFactorySpi skfSpi;
    private Provider provider;
    private String algorithm;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String string) {
        this.skfSpi = secretKeyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return SecretKeyFactory.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return SecretKeyFactory.getInstance(string, provider);
    }

    public static final SecretKeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new SecretKeyFactory((SecretKeyFactorySpi)Engine.getInstance(SERVICE, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() == null) {
                throw new NoSuchAlgorithmException(string);
            }
            if (invocationTargetException.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)invocationTargetException.getCause();
            }
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.skfSpi.engineGenerateSecret(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return this.skfSpi.engineGetKeySpec(secretKey, clazz);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        return this.skfSpi.engineTranslateKey(secretKey);
    }
}

