/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private long gregorianCutover;
    static final long serialVersionUID = -8125100834729963327L;
    private static final String bundleName = "gnu.java.locale.Calendar";
    private static final int EPOCH_DAYS = 719162;
    private static final int[] minimums;
    private static final int[] maximums;

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, locale, false);
        this.setTimeInMillis(System.currentTimeMillis());
        this.complete();
    }

    private GregorianCalendar(TimeZone timeZone, Locale locale, boolean bl) {
        super(timeZone, locale);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale, ClassLoader.getSystemClassLoader());
        this.gregorianCutover = ((Date)resourceBundle.getObject("gregorianCutOver")).getTime();
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(n, n2, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(n, n2, n3, n4, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(n, n2, n3, n4, n5, n6);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n) {
        if ((n & 3) != 0) {
            return false;
        }
        if (!this.isGregorian(n, 59)) {
            return true;
        }
        return n % 100 != 0 || n % 400 == 0;
    }

    private int getWeekDay(int n, int n2) {
        boolean bl = this.isGregorian(n, n2);
        int n3 = (int)this.getLinearDay(n, n2, bl);
        int n4 = (n3 + 5) % 7;
        if (n4 <= 0) {
            n4 += 7;
        }
        return n4;
    }

    private int getFirstDayOfMonth(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        if (n2 > 11) {
            n += n2 / 12;
            n2 %= 12;
        }
        if (n2 < 0) {
            n += n2 / 12;
            if ((n2 %= 12) < 0) {
                n2 += 12;
                --n;
            }
        }
        int n5 = nArray[n2] + 1;
        if (n2 > 1 && this.isLeapYear(n)) {
            ++n5;
        }
        if ((n4 = ((n3 = (int)this.getLinearDay(n, n5, bl = this.isGregorian(n, n5))) + 5) % 7) <= 0) {
            n4 += 7;
        }
        return n4;
    }

    private boolean isGregorian(int n, int n2) {
        int n3 = (n - 1) * 365 + (n - 1 >> 2) + n2 - 719162;
        int n4 = (int)Math.floor((double)(n - 1) / 400.0) - (int)Math.floor((double)(n - 1) / 100.0);
        return (long)(n3 + n4) * (long)60 * (long)60 * (long)24 * (long)1000 >= this.gregorianCutover;
    }

    private void nonLeniencyCheck() throws IllegalArgumentException {
        int n;
        int n2;
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int n3 = this.fields[1];
        int n4 = this.fields[2];
        int n5 = n2 = this.isLeapYear(n3) ? 1 : 0;
        if (this.isSet[0] && this.fields[0] != 1 && this.fields[0] != 0) {
            throw new IllegalArgumentException("Illegal ERA.");
        }
        if (this.isSet[1] && this.fields[1] < 1) {
            throw new IllegalArgumentException("Illegal YEAR.");
        }
        if (this.isSet[2] && (n4 < 0 || n4 > 11)) {
            throw new IllegalArgumentException("Illegal MONTH.");
        }
        if (this.isSet[3]) {
            n = 365 + n2;
            n += this.getFirstDayOfMonth(n3, 0) - 1;
            int n6 = this.getFirstDayOfMonth(n3, 11) + 4;
            if (n6 > 7) {
                n6 -= 7;
            }
            int n7 = (n += 7 - n6) / 7;
            if (this.fields[3] < 1 || this.fields[3] > n7) {
                throw new IllegalArgumentException("Illegal WEEK_OF_YEAR.");
            }
        }
        if (this.isSet[4]) {
            int n8 = n = n4 == 1 && n2 == 0 ? 4 : 5;
            if (this.fields[4] < 1 || this.fields[4] > n) {
                throw new IllegalArgumentException("Illegal WEEK_OF_MONTH.");
            }
        }
        if (this.isSet[5] && (this.fields[5] < 1 || this.fields[5] > nArray[n4] + (n4 == 1 ? n2 : 0))) {
            throw new IllegalArgumentException("Illegal DAY_OF_MONTH.");
        }
        if (this.isSet[6] && (this.fields[6] < 1 || this.fields[6] > 365 + n2)) {
            throw new IllegalArgumentException("Illegal DAY_OF_YEAR.");
        }
        if (this.isSet[7] && (this.fields[7] < 1 || this.fields[7] > 7)) {
            throw new IllegalArgumentException("Illegal DAY_OF_WEEK.");
        }
        if (this.isSet[8]) {
            int n9 = n = n4 == 1 && n2 == 0 ? 4 : 5;
            if (this.fields[8] < -n || this.fields[8] > n) {
                throw new IllegalArgumentException("Illegal DAY_OF_WEEK_IN_MONTH.");
            }
        }
        if (this.isSet[9] && this.fields[9] != 0 && this.fields[9] != 1) {
            throw new IllegalArgumentException("Illegal AM_PM.");
        }
        if (this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
            throw new IllegalArgumentException("Illegal HOUR.");
        }
        if (this.isSet[11] && (this.fields[11] < 0 || this.fields[11] > 23)) {
            throw new IllegalArgumentException("Illegal HOUR_OF_DAY.");
        }
        if (this.isSet[12] && (this.fields[12] < 0 || this.fields[12] > 59)) {
            throw new IllegalArgumentException("Illegal MINUTE.");
        }
        if (this.isSet[13] && (this.fields[13] < 0 || this.fields[13] > 59)) {
            throw new IllegalArgumentException("Illegal SECOND.");
        }
        if (this.isSet[14] && (this.fields[14] < 0 || this.fields[14] > 999)) {
            throw new IllegalArgumentException("Illegal MILLISECOND.");
        }
        if (this.isSet[15] && ((long)this.fields[15] < -43200000L || (long)this.fields[15] > 43200000L)) {
            throw new IllegalArgumentException("Illegal ZONE_OFFSET.");
        }
        if (this.isSet[16] && ((long)this.fields[16] < -43200000L || (long)this.fields[16] > 43200000L)) {
            throw new IllegalArgumentException("Illegal DST_OFFSET.");
        }
    }

    protected synchronized void computeTime() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = this.fields[0];
        int n9 = this.fields[1];
        int n10 = this.fields[2];
        int n11 = this.fields[5];
        int n12 = this.fields[12];
        int n13 = this.fields[13];
        int n14 = this.fields[14];
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] nArray2 = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int n15 = 0;
        if (!this.isLenient()) {
            this.nonLeniencyCheck();
        }
        if (!(this.isSet[2] || this.isSet[7] && !this.isSet[3])) {
            if (this.isSet[3]) {
                n6 = this.getFirstDayOfMonth(n9, 0);
                n5 = 1;
                n4 = this.getFirstDayOfWeek() - n6;
                if (n4 <= 0) {
                    n4 += 7;
                }
                n5 = n4 < this.getMinimalDaysInFirstWeek() ? (n5 += n4) : (n5 -= 7 - n4);
                n10 = 0;
                n11 = n5 + 7 * (this.fields[3] - 1);
                n5 = this.fields[7] - this.getFirstDayOfWeek();
                if (n5 < 0) {
                    n5 += 7;
                }
                n11 += n5;
            } else {
                n10 = 0;
                n11 = this.fields[6];
            }
        } else if (this.isSet[7]) {
            n6 = this.getFirstDayOfMonth(n9, n10);
            if (this.isSet[8]) {
                if (this.fields[8] < 0) {
                    n6 = this.getFirstDayOfMonth(n9, ++n10);
                    n11 = 1 + 7 * this.fields[8];
                } else {
                    n11 = 1 + 7 * (this.fields[8] - 1);
                }
                n5 = this.fields[7] - n6;
                if (n5 < 0) {
                    n5 += 7;
                }
                n11 += n5;
            } else {
                n5 = 1;
                n4 = this.getFirstDayOfWeek() - n6;
                if (n4 <= 0) {
                    n4 += 7;
                }
                n5 = n4 < this.getMinimalDaysInFirstWeek() ? (n5 += n4) : (n5 -= 7 - n4);
                n11 = n5 + 7 * (this.fields[4] - 1);
                n5 = this.fields[7] - this.getFirstDayOfWeek();
                if (n5 <= 0) {
                    n5 += 7;
                }
                n11 += n5;
            }
        }
        if (n8 == 0 && n9 > 0) {
            n9 = 1 - n9;
        }
        if (this.isSet[10]) {
            n15 = this.fields[10];
            if (this.fields[9] == 1) {
                n15 += 12;
            }
        } else {
            n15 = this.fields[11];
        }
        long l = (((long)n15 * (long)60 + (long)n12) * (long)60 + (long)n13) * (long)1000 + (long)n14;
        n11 = (int)(l / 86400000L) + n11;
        n7 = (int)(l % 86400000L);
        if (n10 < 0) {
            n9 += n10 / 12;
            if ((n10 %= 12) < 0) {
                n10 += 12;
                --n9;
            }
        }
        if (n10 > 11) {
            n9 += n10 / 12;
            n10 %= 12;
        }
        int n16 = nArray[1] = this.isLeapYear(n9) ? 29 : 28;
        while (n11 <= 0) {
            if (n10 == 0) {
                nArray[1] = this.isLeapYear(--n9) ? 29 : 28;
            }
            n10 = (n10 + 11) % 12;
            n11 += nArray[n10];
        }
        while (n11 > nArray[n10]) {
            n11 -= nArray[n10];
            if ((n10 = (n10 + 1) % 12) != 0) continue;
            nArray[1] = this.isLeapYear(++n9) ? 29 : 28;
        }
        n4 = nArray2[n10] + n11 - 1;
        if (this.isLeapYear(n9) && n10 > 1) {
            ++n4;
        }
        n3 = (long)((n3 = (n9 - 1) * 365 + (n9 - 1 >> 2) + n4 - 719162) + (n2 = (int)Math.floor((double)(n9 - 1) / 400.0) - (int)Math.floor((double)(n9 - 1) / 100.0))) * (long)60 * (long)60 * (long)24 * (long)1000 >= this.gregorianCutover ? (n3 += n2) : (n3 -= 2);
        this.time = (long)n3 * 86400000L + (long)n7;
        int n17 = (n3 + 5) % 7;
        if (n17 <= 0) {
            n17 += 7;
        }
        this.fields[7] = n17;
        TimeZone timeZone = this.getTimeZone();
        int n18 = n = this.isSet[15] ? this.fields[15] : timeZone.getRawOffset();
        int n19 = this.isSet[16] ? this.fields[16] : timeZone.getOffset(n9 < 0 ? 0 : 1, n9 < 0 ? 1 - n9 : n9, n10, n11, n17, n7) - timeZone.getRawOffset();
        this.time -= (long)(n + n19);
        this.isTimeSet = true;
    }

    private long getLinearDay(int n, int n2, boolean bl) {
        long l = (long)(n - 1) * (long)365 + (long)(n - 1 >> 2) + (long)(n2 - 1) - 719162L;
        if (bl) {
            int n3 = (int)Math.floor((double)(n - 1) / 400.0) - (int)Math.floor((double)(n - 1) / 100.0);
            return l + (long)n3;
        }
        return l -= (long)2;
    }

    private void calculateDay(int[] nArray, long l, boolean bl) {
        int n;
        long l2;
        int n2 = ((int)l + 5) % 7;
        if (n2 <= 0) {
            n2 += 7;
        }
        nArray[7] = n2;
        int n3 = 1970 + (bl ? (int)((l - (long)100) * (long)400 / 146097L) : (int)((l - (long)100) * (long)4 / (long)1461));
        if (l >= 0L) {
            ++n3;
        }
        if (l < (l2 = this.getLinearDay(n3, 1, bl))) {
            l2 = this.getLinearDay(--n3, 1, bl);
        }
        nArray[6] = (int)(l -= l2 - 1L);
        if (n3 <= 0) {
            nArray[0] = 0;
            nArray[1] = 1 - n3;
        } else {
            nArray[0] = 1;
            nArray[1] = n3;
        }
        int n4 = n = this.isLeapYear(n3) ? 1 : 0;
        if (l <= (long)(59 + n)) {
            nArray[2] = (int)l / 32;
            nArray[5] = (int)l - 31 * nArray[2];
        } else {
            int n5 = ((int)l - n) * 5 + 8;
            nArray[2] = n5 / 153;
            nArray[5] = n5 % 153 / 5 + 1;
        }
    }

    protected synchronized void computeFields() {
        int n;
        int n2;
        boolean bl = this.time >= this.gregorianCutover;
        TimeZone timeZone = this.getTimeZone();
        this.fields[15] = timeZone.getRawOffset();
        long l = this.time + (long)this.fields[15];
        long l2 = l / 86400000L;
        int n3 = (int)(l % 86400000L);
        if (n3 < 0) {
            n3 += 86400000;
            --l2;
        }
        this.calculateDay(this.fields, l2, bl);
        this.fields[16] = timeZone.getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], n3) - this.fields[15];
        if ((n3 += this.fields[16]) >= 86400000) {
            n3 -= 86400000;
            this.calculateDay(this.fields, ++l2, bl);
        }
        this.fields[8] = (this.fields[5] + 6) / 7;
        int n4 = (7 + this.fields[7] - this.getFirstDayOfWeek()) % 7;
        this.fields[4] = (this.fields[5] - n4 + 12) / 7;
        int n5 = (this.fields[6] - n4 + 6) / 7;
        int n6 = this.getMinimalDaysInFirstWeek();
        if (n6 - (n2 = (7 + this.getWeekDay(this.fields[1], n6) - this.getFirstDayOfWeek()) % 7) < 1) {
            // empty if block
        }
        this.fields[3] = ++n5;
        int n7 = n3 / 3600000;
        this.fields[9] = n7 < 12 ? 0 : 1;
        this.fields[10] = n = n7 % 12;
        this.fields[11] = n7;
        this.fields[12] = (n3 %= 3600000) / 60000;
        this.fields[13] = (n3 %= 60000) / 1000;
        this.fields[14] = n3 % 1000;
        this.isSet[16] = true;
        this.isSet[15] = true;
        this.isSet[14] = true;
        this.isSet[13] = true;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[10] = true;
        this.isSet[9] = true;
        this.isSet[8] = true;
        this.isSet[7] = true;
        this.isSet[6] = true;
        this.isSet[5] = true;
        this.isSet[4] = true;
        this.isSet[3] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[0] = true;
        this.areFieldsSet = true;
    }

    public int hashCode() {
        int n = (int)(this.gregorianCutover >>> 32) ^ (int)this.gregorianCutover;
        return super.hashCode() ^ n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return gregorianCalendar.gregorianCutover == this.gregorianCutover && super.equals(object);
    }

    public void add(int n, int n2) {
        switch (n) {
            case 1: {
                this.complete();
                this.fields[1] = this.fields[1] + n2;
                this.isTimeSet = false;
                break;
            }
            case 2: {
                int n3;
                this.complete();
                int n4 = this.fields[2] + n2;
                this.fields[1] = this.fields[1] + n4 / 12;
                this.fields[2] = n4 % 12;
                if (this.fields[2] < 0) {
                    this.fields[2] = this.fields[2] + 12;
                    this.fields[1] = this.fields[1] - 1;
                }
                if (this.fields[5] > (n3 = this.getActualMaximum(5))) {
                    this.fields[5] = n3;
                }
                this.set(1, this.fields[1]);
                this.set(2, this.fields[2]);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 86400000L;
                this.areFieldsSet = false;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 604800000L;
                this.areFieldsSet = false;
                break;
            }
            case 9: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 43200000L;
                this.areFieldsSet = false;
                break;
            }
            case 10: 
            case 11: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 3600000L;
                this.areFieldsSet = false;
                break;
            }
            case 12: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 60000L;
                this.areFieldsSet = false;
                break;
            }
            case 13: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * (long)1000;
                this.areFieldsSet = false;
                break;
            }
            case 14: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2;
                this.areFieldsSet = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or unknown field");
            }
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    private void cleanUpAfterRoll(int n, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (this.fields[5] > this.getActualMaximum(5)) {
                    this.fields[5] = this.getActualMaximum(5);
                }
                this.isTimeSet = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 86400000L;
                break;
            }
            case 4: {
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 604800000L;
                break;
            }
            case 8: {
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 604800000L;
                break;
            }
            case 6: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 86400000L;
                break;
            }
            case 3: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.time += (long)n2 * 604800000L;
                break;
            }
            case 9: {
                this.isSet[11] = false;
                this.time += (long)n2 * 43200000L;
                break;
            }
            case 10: {
                this.isSet[11] = false;
                this.time += (long)n2 * 3600000L;
                break;
            }
            case 11: {
                this.isSet[10] = false;
                this.isSet[9] = false;
                this.time += (long)n2 * 3600000L;
                break;
            }
            case 12: {
                this.time += (long)n2 * 60000L;
                break;
            }
            case 13: {
                this.time += (long)n2 * (long)1000;
                break;
            }
            case 14: {
                this.time += (long)n2;
            }
        }
    }

    public void roll(int n, int n2) {
        switch (n) {
            case 7: {
                this.add(n, n2);
                return;
            }
            case 15: 
            case 16: {
                throw new IllegalArgumentException("Can't roll time zone");
            }
        }
        this.complete();
        int n3 = this.getActualMinimum(n);
        int n4 = this.getActualMaximum(n) - n3 + 1;
        int n5 = this.fields[n];
        int n6 = (n5 - n3 + n4 + n2) % n4 + n3;
        if (n6 < n3) {
            n6 += n4;
        }
        this.fields[n] = n6;
        this.cleanUpAfterRoll(n, n6 - n5);
    }

    public int getMinimum(int n) {
        return minimums[n];
    }

    public int getMaximum(int n) {
        return maximums[n];
    }

    public int getGreatestMinimum(int n) {
        if (n == 3) {
            return 1;
        }
        return minimums[n];
    }

    public int getLeastMaximum(int n) {
        switch (n) {
            case 3: {
                return 52;
            }
            case 5: {
                return 28;
            }
            case 6: {
                return 365;
            }
            case 4: 
            case 8: {
                return 4;
            }
        }
        return maximums[n];
    }

    public int getActualMinimum(int n) {
        if (n == 3) {
            int n2;
            int n3;
            int n4 = this.getMinimalDaysInFirstWeek();
            if (n4 == 0) {
                return 1;
            }
            if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                this.complete();
            }
            if ((7 + (n3 = this.getWeekDay(n2 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1], n4)) - this.getFirstDayOfWeek()) % 7 >= n4 - 1) {
                return 1;
            }
            return 0;
        }
        return minimums[n];
    }

    public int getActualMaximum(int n) {
        switch (n) {
            case 3: {
                int n2;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n3 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                int n4 = this.isLeapYear(n3) ? 366 : 365;
                int n5 = this.getWeekDay(n3, n4);
                int n6 = (n4 + 6 - (7 + n5 - this.getFirstDayOfWeek()) % 7) / 7;
                int n7 = this.getMinimalDaysInFirstWeek();
                if (n7 - (7 + (n2 = this.getWeekDay(n3, n7)) - this.getFirstDayOfWeek()) % 7 < 1) {
                    return n6 + 1;
                }
            }
            case 5: {
                int n4;
                int n3;
                if (!this.areFieldsSet || !this.isSet[2]) {
                    this.complete();
                }
                if ((n3 = this.fields[2]) == 1) {
                    if (!this.isSet[1] || !this.isSet[0]) {
                        this.complete();
                    }
                    int n8 = n4 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                    if (this.isLeapYear(n4)) {
                        return 29;
                    }
                    return 28;
                }
                if (n3 < 7) {
                    return 31 - (n3 & 1);
                }
                return 30 + (n3 & 1);
            }
            case 6: {
                int n9;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n10 = n9 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                if (this.isLeapYear(n9)) {
                    return 366;
                }
                return 365;
            }
            case 8: {
                int n11 = this.getActualMaximum(5);
                return (n11 - (this.fields[5] - 1) % 7 + 6) / 7;
            }
            case 4: {
                int n12 = this.getActualMaximum(5);
                int n13 = (n12 - this.fields[5] + this.fields[7] - 1) % 7 + 1;
                return (n12 + 6 - (7 + n13 - this.getFirstDayOfWeek()) % 7) / 7;
            }
        }
        return maximums[n];
    }

    static {
        bundleName = bundleName;
        minimums = new int[]{0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, -43200000, 0};
        maximums = new int[]{1, 5000000, 11, 53, 5, 31, 366, 7, 5, 1, 12, 23, 59, 59, 999, 43200000, 43200000};
    }
}

