/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.peer.FileDialogPeer;
import java.io.FilenameFilter;
import java.io.Serializable;

public class FileDialog
extends Dialog
implements Serializable {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private static final long serialVersionUID = 5035145889651310422L;
    private String dir;
    private String file;
    private FilenameFilter filter;
    private int mode;

    public FileDialog(Dialog dialog) {
        this(dialog, "", 0);
    }

    public FileDialog(Dialog dialog, String string) {
        this(dialog, string, 0);
    }

    public FileDialog(Dialog dialog, String string, int n) {
        super(dialog, string, true);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Mode argument must be either LOAD or SAVE");
        }
        this.setMode(n);
    }

    public FileDialog(Frame frame) {
        this(frame, "", 0);
    }

    public FileDialog(Frame frame, String string) {
        this(frame, string, 0);
    }

    public FileDialog(Frame frame, String string, int n) {
        super(frame, string, true);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Mode argument must be either LOAD or SAVE");
        }
        this.setMode(n);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Bad mode: " + n);
        }
        this.mode = n;
    }

    public String getDirectory() {
        return this.dir;
    }

    public synchronized void setDirectory(String string) {
        this.dir = string;
        if (this.peer != null) {
            FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
            fileDialogPeer.setDirectory(string);
        }
    }

    public String getFile() {
        return this.file;
    }

    public synchronized void setFile(String string) {
        this.file = string;
        if (this.peer != null) {
            FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
            fileDialogPeer.setFile(string);
        }
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        if (this.peer != null) {
            FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
            fileDialogPeer.setFilenameFilter(filenameFilter);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createFileDialog(this);
        }
        super.addNotify();
    }

    protected String paramString() {
        return "dir=" + this.dir + ",file=" + this.file + ",mode=" + this.mode + "," + super.paramString();
    }
}

