/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    Dimension maxSize;
    boolean focusCycleRoot;
    private boolean focusTraversalPolicyProvider;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (n < 0 || n >= this.ncomponents) {
                    throw new ArrayIndexOutOfBoundsException("no such component");
                }
                Component component = this.component[n];
                Object var4_4 = null;
                return component;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Component[] componentArray = new Component[this.ncomponents];
                if (this.ncomponents > 0) {
                    System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
                }
                Component[] componentArray2 = componentArray;
                Object var4_4 = null;
                return componentArray2;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            try {
                Object object3;
                int n2;
                int n3;
                if (n > this.ncomponents || n < 0 && n != -1 || component instanceof Window || component instanceof Container && ((Container)component).isAncestorOf(this)) {
                    throw new IllegalArgumentException();
                }
                if (component.parent != null) {
                    component.parent.remove(component);
                }
                component.parent = this;
                if (this.peer != null) {
                    component.addNotify();
                    if (component.isLightweight()) {
                        this.enableEvents(component.eventMask);
                        if (!this.isLightweight()) {
                            this.enableEvents(8192);
                        }
                    }
                }
                component.invalidate();
                if (this.component == null) {
                    this.component = new Component[4];
                }
                if (this.ncomponents >= this.component.length) {
                    n3 = this.component.length * 2;
                    Component[] componentArray = new Component[n3];
                    System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
                    this.component = componentArray;
                }
                if (n == -1) {
                    this.component[this.ncomponents++] = component;
                } else {
                    System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                    this.component[n] = component;
                    ++this.ncomponents;
                }
                n3 = component.numHierarchyListeners;
                if (n3 > 0) {
                    this.updateHierarchyListenerCount(32768L, n3);
                }
                if ((n2 = component.numHierarchyBoundsListeners) > 0) {
                    this.updateHierarchyListenerCount(65536L, n3);
                }
                if (this.layoutMgr != null) {
                    if (this.layoutMgr instanceof LayoutManager2) {
                        object3 = (LayoutManager2)this.layoutMgr;
                        object3.addLayoutComponent(component, object);
                    } else if (object instanceof String) {
                        this.layoutMgr.addLayoutComponent((String)object, component);
                    } else {
                        this.layoutMgr.addLayoutComponent("", component);
                    }
                }
                object3 = new ContainerEvent(this, 300, component);
                ContainerListener[] containerListenerArray = this.getContainerListeners();
                for (int i = 0; i < containerListenerArray.length; ++i) {
                    containerListenerArray[i].componentAdded((ContainerEvent)object3);
                }
                component.fireHierarchyEvent(1400, component, this, 1L);
            }
            finally {
                Object var5_6 = null;
            }
            return;
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            try {
                int n2;
                int n3;
                component = this.component[n];
                ComponentListener[] componentListenerArray = component.getComponentListeners();
                for (n3 = 0; n3 < componentListenerArray.length; ++n3) {
                    component.removeComponentListener(componentListenerArray[n3]);
                }
                component.removeNotify();
                System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
                this.component[--this.ncomponents] = null;
                n3 = component.numHierarchyListeners;
                if (n3 > 0) {
                    this.updateHierarchyListenerCount(32768L, -n3);
                }
                if ((n2 = component.numHierarchyBoundsListeners) > 0) {
                    this.updateHierarchyListenerCount(65536L, -n3);
                }
                this.invalidate();
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.isShowing()) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.getToolkit().getSystemEventQueue().postEvent(containerEvent);
                }
                component.fireHierarchyEvent(1400, component, this, 1L);
            }
            finally {
                component = null;
            }
            return;
        }
    }

    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    if (this.component[i] != component) continue;
                    this.remove(i);
                    break;
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    Component component = this.component[i];
                    ComponentListener[] componentListenerArray = component.getComponentListeners();
                    for (int j = 0; j < componentListenerArray.length; ++j) {
                        component.removeComponentListener(componentListenerArray[j]);
                    }
                    component.removeNotify();
                    if (this.layoutMgr != null) {
                        this.layoutMgr.removeLayoutComponent(component);
                    }
                    component.parent = null;
                    if (!this.isShowing()) continue;
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.getToolkit().getSystemEventQueue().postEvent(containerEvent);
                }
                this.invalidate();
                this.ncomponents = 0;
            }
            finally {
                Object var2_3 = null;
            }
            return;
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
    }

    public void validate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            block3: {
                try {
                    if (this.isValid() || this.peer == null) break block3;
                    this.validateTree();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            block4: {
                try {
                    super.invalidate();
                    for (int i = 0; i < this.ncomponents; ++i) {
                        Component component = this.component[i];
                        component.invalidate();
                        if (!(component instanceof Container)) continue;
                        ((Container)component).invalidateTree();
                    }
                    if (this.layoutMgr == null || !(this.layoutMgr instanceof LayoutManager2)) break block4;
                    LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                    layoutManager2.invalidateLayout(this);
                }
                catch (Throwable throwable) {
                    Object var2_5 = null;
                    throw throwable;
                }
            }
            Object var2_4 = null;
        }
    }

    protected void validateTree() {
        Component component;
        int n;
        if (this.valid) {
            return;
        }
        ContainerPeer containerPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            containerPeer = (ContainerPeer)this.peer;
            containerPeer.beginValidate();
        }
        for (n = 0; n < this.ncomponents; ++n) {
            component = this.component[n];
            if (component.getPeer() != null) continue;
            component.addNotify();
        }
        this.doLayout();
        for (n = 0; n < this.ncomponents; ++n) {
            component = this.component[n];
            if (component.isValid()) continue;
            if (component instanceof Container) {
                ((Container)component).validateTree();
                continue;
            }
            this.component[n].validate();
        }
        this.valid = true;
        if (containerPeer != null) {
            containerPeer.endValidate();
        }
    }

    public void setFont(Font font) {
        if (font != null && (this.font == null || !this.font.equals(font)) || font == null) {
            super.setFont(font);
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension == null || !this.prefSizeSet && !this.valid) {
            Object object;
            Object object2 = this.getTreeLock();
            // MONITORENTER : object2
            try {
                object = this.layoutMgr;
                this.prefSize = object != null ? object.preferredLayoutSize(this) : super.preferredSizeImpl();
                dimension = this.prefSize;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                // MONITOREXIT : object2
                throw throwable;
            }
            object = null;
            // MONITOREXIT : object2
        }
        if (dimension == null) return dimension;
        return new Dimension(dimension);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension == null || !this.minSizeSet && !this.valid) {
            Object object;
            Object object2 = this.getTreeLock();
            // MONITORENTER : object2
            try {
                object = this.layoutMgr;
                this.minSize = object != null ? object.minimumLayoutSize(this) : super.minimumSizeImpl();
                dimension = this.minSize;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                // MONITOREXIT : object2
                throw throwable;
            }
            object = null;
            // MONITOREXIT : object2
        }
        if (dimension == null) return dimension;
        return new Dimension(dimension);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension == null || !this.maxSizeSet && !this.valid) {
            Object object;
            Object object2 = this.getTreeLock();
            // MONITORENTER : object2
            try {
                object = this.layoutMgr;
                this.maxSize = object instanceof LayoutManager2 ? ((LayoutManager2)object).maximumLayoutSize(this) : super.maximumSizeImpl();
                dimension = this.maxSize;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                // MONITOREXIT : object2
                throw throwable;
            }
            object = null;
            // MONITOREXIT : object2
        }
        if (dimension == null) return dimension;
        return new Dimension(dimension);
    }

    public float getAlignmentX() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2;
                try {
                    layoutManager2 = (LayoutManager2)layoutManager;
                    f = layoutManager2.getLayoutAlignmentX(this);
                }
                finally {
                    layoutManager2 = null;
                }
            }
        } else {
            f = super.getAlignmentX();
        }
        {
            float f2 = f;
            return f2;
        }
    }

    public float getAlignmentY() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2;
                try {
                    layoutManager2 = (LayoutManager2)layoutManager;
                    f = layoutManager2.getLayoutAlignmentY(this);
                }
                finally {
                    layoutManager2 = null;
                }
            }
        } else {
            f = super.getAlignmentY();
        }
        {
            float f2 = f;
            return f2;
        }
    }

    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            this.visitChildren(graphics, GfxPaintVisitor.INSTANCE, true);
        }
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            ComponentPeer componentPeer = this.peer;
            if (!(componentPeer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.paint(graphics);
        }
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        this.visitChildren(graphics, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics graphics) {
        this.paint(graphics);
        this.visitChildren(graphics, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics graphics) {
        super.paint(graphics);
        this.visitChildren(graphics, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])AWTEventMulticaster.getListeners(this.containerListener, Container.class$("java.awt.event.ContainerListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Container.class$("java.awt.event.ContainerListener")) {
            return this.getContainerListeners();
        }
        return super.getListeners(clazz);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener == null) {
            return;
        }
        switch (containerEvent.id) {
            case 300: {
                this.containerListener.componentAdded(containerEvent);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(containerEvent);
            }
        }
    }

    public void deliverEvent(Event event) {
        if (!this.handleEvent(event)) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Container container;
                block4: {
                    try {
                        container = this.getParent();
                        if (container == null) break block4;
                        ((Component)container).deliverEvent(event);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        throw throwable;
                    }
                }
                container = null;
            }
        }
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component locate(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(n, n2)) {
                    return null;
                }
                for (int i = 0; i < this.ncomponents; ++i) {
                    Component component = this.component[i];
                    int n3 = n - component.x;
                    int n4 = n2 - component.y;
                    if (!component.contains(n3, n4) || component.isLightweight()) continue;
                    return component;
                }
                int n5 = 0;
                while (n5 < this.ncomponents) {
                    Component component = this.component[n5];
                    int n6 = n - component.x;
                    int n7 = n2 - component.y;
                    if (component.contains(n6, n7) && component.isLightweight()) {
                        return component;
                    }
                    ++n5;
                }
                return this;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                throw throwable;
            }
        }
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component findComponentAt(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(n, n2)) {
                    return null;
                }
                int n3 = 0;
                while (n3 < this.ncomponents) {
                    if (this.component[n3].isVisible()) {
                        int n4 = n - this.component[n3].x;
                        int n5 = n2 - this.component[n3].y;
                        if (this.component[n3] instanceof Container) {
                            Container container = (Container)this.component[n3];
                            Component component = container.findComponentAt(n4, n5);
                            if (component != null) {
                                return component;
                            }
                        } else if (this.component[n3].contains(n4, n5)) {
                            return this.component[n3];
                        }
                    }
                    ++n3;
                }
                return this;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                throw throwable;
            }
        }
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.addNotify();
                this.addNotifyContainerChildren();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].removeNotify();
                }
                super.removeNotify();
            }
            finally {
                Object var2_3 = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAncestorOf(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                while (true) {
                    if (component == null) {
                        return false;
                    }
                    if (component == this) {
                        return true;
                    }
                    component = component.getParent();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                throw throwable;
            }
        }
    }

    protected String paramString() {
        if (this.layoutMgr == null) {
            return super.paramString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.paramString());
        stringBuffer.append(",layout=");
        stringBuffer.append(this.layoutMgr.getClass().getName());
        return stringBuffer.toString();
    }

    public void list(PrintStream printStream, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.list(printStream, n);
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].list(printStream, n + 2);
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    public void list(PrintWriter printWriter, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.list(printWriter, n);
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].list(printWriter, n + 2);
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    public void setFocusTraversalKeys(int n, Set set) {
        Set set2;
        Set set3;
        Set set4;
        Object object;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        if (set == null) {
            for (object = this.getParent(); object != null; object = ((Component)object).getParent()) {
                if (!((Container)object).areFocusTraversalKeysSet(n)) continue;
                set = ((Container)object).getFocusTraversalKeys(n);
                break;
            }
            if (set == null) {
                set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
            }
        }
        switch (n) {
            case 0: {
                set4 = this.getFocusTraversalKeys(1);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                object = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                set4 = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                object = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                set4 = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(3);
                object = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                set4 = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(2);
                object = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator iterator = set.iterator();
        while (--n2 >= 0) {
            Object object2 = iterator.next();
            if (object2 instanceof AWTKeyStroke && !set4.contains(object2) && !set3.contains(object2) && !set2.contains(object2) && ((AWTKeyStroke)object2).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[4];
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        this.firePropertyChange((String)object, this.focusTraversalKeys[n], set);
        this.focusTraversalKeys[n] = set;
    }

    public Set getFocusTraversalKeys(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        Set set = null;
        if (this.focusTraversalKeys != null) {
            set = this.focusTraversalKeys[n];
        }
        if (set == null && this.parent != null) {
            set = this.parent.getFocusTraversalKeys(n);
        }
        if (set == null) {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
        }
        return set;
    }

    public boolean areFocusTraversalKeysSet(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null;
    }

    public boolean isFocusCycleRoot(Container container) {
        if (this == container && this.isFocusCycleRoot()) {
            return true;
        }
        Container container2 = this.getFocusCycleRootAncestor();
        return container == container2;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this.focusTraversalPolicy = focusTraversalPolicy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container container = this.getFocusCycleRootAncestor();
            if (container != this && container != null) {
                return container.getFocusTraversalPolicy();
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return keyboardFocusManager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy == null;
    }

    public void setFocusCycleRoot(boolean bl) {
        this.focusCycleRoot = bl;
    }

    public final boolean isFocusTraversalPolicyProvider() {
        return this.focusTraversalPolicyProvider;
    }

    public final void setFocusTraversalPolicyProvider(boolean bl) {
        this.focusTraversalPolicyProvider = bl;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.setGlobalCurrentFocusCycleRoot(this);
            FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy();
            Component component = focusTraversalPolicy.getDefaultComponent(this);
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
        this.setComponentOrientation(componentOrientation);
        for (int i = 0; i < this.ncomponents; ++i) {
            if (this.component[i] instanceof Container) {
                ((Container)this.component[i]).applyComponentOrientation(componentOrientation);
                continue;
            }
            this.component[i].setComponentOrientation(componentOrientation);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void setComponentZOrder(Component component, int n) {
        if (component == null) {
            throw new NullPointerException("comp must not be null");
        }
        if (component instanceof Container && ((Container)component).isAncestorOf(this)) {
            throw new IllegalArgumentException("comp must not be an ancestor of this");
        }
        if (component instanceof Window) {
            throw new IllegalArgumentException("comp must not be a Window");
        }
        if (component == this) {
            throw new IllegalArgumentException("cannot add component to itself");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (component.getParent() != this) {
                    throw new AssertionError((Object)"Reparenting is not implemented yet");
                }
                int n2 = this.getComponentZOrder(component);
                if (n2 < n) {
                    System.arraycopy(this.component, n2 + 1, this.component, n2, n - n2);
                } else {
                    System.arraycopy(this.component, n, this.component, n + 1, n2 - n);
                }
                this.component[n] = component;
            }
            finally {
                Object var4_5 = null;
            }
            return;
        }
    }

    public final int getComponentZOrder(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int n;
                int n2 = -1;
                if (this.component != null) {
                    for (n = 0; n < this.ncomponents; ++n) {
                        if (this.component[n] != component) continue;
                        n2 = n;
                        break;
                    }
                }
                n = n2;
                Object var5_5 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    private void visitChildren(Graphics graphics, GfxVisitor gfxVisitor, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = this.ncomponents - 1; i >= 0; --i) {
                    boolean bl2;
                    Component component = this.component[i];
                    boolean bl3 = bl2 = component.isVisible() && (component.isLightweight() || !bl);
                    if (!bl2) continue;
                    this.visitChild(graphics, gfxVisitor, component);
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }

    private void visitChild(Graphics graphics, GfxVisitor gfxVisitor, Component component) {
        Rectangle rectangle = component.getBounds();
        if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
            return;
        }
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            gfxVisitor.visit(component, graphics2);
        }
        finally {
            Object var6_6 = null;
            graphics2.dispose();
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        boolean bl = LightweightDispatcher.getInstance().dispatchEvent(aWTEvent);
        if (!bl) {
            if (aWTEvent.id <= 301 && aWTEvent.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
                this.processEvent(aWTEvent);
            } else {
                super.dispatchEventImpl(aWTEvent);
            }
        }
    }

    boolean eventTypeEnabled(int n) {
        if (n <= 301 && n >= 300) {
            return this.containerListener != null || (this.eventMask & (long)2) != 0L;
        }
        return super.eventTypeEnabled(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Component findNextFocusComponent(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int n;
                int n2;
                if (component != null) {
                    for (n2 = 0; n2 < this.ncomponents && this.component[n2] != component; ++n2) {
                    }
                    n = n2;
                    if (n == 0) {
                        n = this.ncomponents;
                    }
                    ++n2;
                } else {
                    n2 = 0;
                    n = this.ncomponents;
                }
                int n3 = n2;
                while (n3 != n) {
                    if (n3 >= this.ncomponents) {
                        if (this.parent != null) {
                            return this.parent.findNextFocusComponent(this);
                        }
                        n3 -= this.ncomponents;
                    }
                    if (this.component[n3] instanceof Container) {
                        Component component2 = this.component[n3];
                        if ((component2 = component2.findNextFocusComponent(null)) != null) {
                            return component2;
                        }
                    } else if (this.component[n3].isFocusTraversable()) {
                        return this.component[n3];
                    }
                    ++n3;
                }
                return null;
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                throw throwable;
            }
        }
    }

    void fireHierarchyEvent(int n, Component component, Container container, long l) {
        if (n == 1400 && this.numHierarchyListeners > 0 || (n == 1401 || n == 1402) && this.numHierarchyBoundsListeners > 0) {
            for (int i = 0; i < this.ncomponents; ++i) {
                this.component[i].fireHierarchyEvent(n, component, container, l);
            }
            super.fireHierarchyEvent(n, component, container, l);
        }
    }

    void updateHierarchyListenerCount(long l, int n) {
        if (l == 65536L) {
            this.numHierarchyBoundsListeners += n;
        } else if (l == 32768L) {
            this.numHierarchyListeners += n;
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if (this.parent != null) {
            this.parent.updateHierarchyListenerCount(l, n);
        }
    }

    private void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int n = this.ncomponents;
                while (--n >= 0) {
                    this.component[n].addNotify();
                    if (!this.component[n].isLightweight()) continue;
                    this.enableEvents(this.component[n].eventMask);
                    if (this.peer == null || this.isLightweight()) continue;
                    this.enableEvents(8192);
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        while (string != null) {
            Object object = objectInputStream.readObject();
            if ("containerL".equals(string)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(string)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            string = (String)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    static {
        $assertionsDisabled = Container.class$("java.awt.Container").desiredAssertionStatus() ^ true;
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private /* synthetic */ Container this$0;
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler;

        private /* synthetic */ void finit$() {
            this.accessibleContainerHandler = new AccessibleContainerHandler(this);
        }

        protected AccessibleAWTContainer(Container container) {
            this.this$0 = container;
            super(container);
            this.finit$();
            container.addContainerListener(this.accessibleContainerHandler);
        }

        public int getAccessibleChildrenCount() {
            Object object = this.this$0.getTreeLock();
            synchronized (object) {
                try {
                    int n;
                    int n2 = 0;
                    int n3 = n = this.this$0.component == null ? 0 : this.this$0.component.length;
                    while (--n >= 0) {
                        if (!(this.this$0.component[n] instanceof Accessible)) continue;
                        ++n2;
                    }
                    int n4 = n2;
                    Object var5_5 = null;
                    return n4;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Accessible getAccessibleChild(int n) {
            Object object = this.this$0.getTreeLock();
            synchronized (object) {
                try {
                    if (this.this$0.component == null) {
                        return null;
                    }
                    int n2 = -1;
                    while (n >= 0 && ++n2 < this.this$0.component.length) {
                        if (!(this.this$0.component[n2] instanceof Accessible)) continue;
                        --n;
                    }
                    if (n >= 0) return null;
                    return (Accessible)((Object)this.this$0.component[n2]);
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    throw throwable;
                }
            }
        }

        public Accessible getAccessibleAt(Point point) {
            Component component = this.this$0.getComponentAt(point.x, point.y);
            if (component != this.this$0 && component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleAWTContainer this$1;

            protected AccessibleContainerHandler(AccessibleAWTContainer accessibleAWTContainer) {
                this.this$1 = accessibleAWTContainer;
            }

            public void componentAdded(ContainerEvent containerEvent) {
                this.this$1.firePropertyChange("AccessibleChild", null, containerEvent.getChild());
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                this.this$1.firePropertyChange("AccessibleChild", containerEvent.getChild(), null);
            }
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.printAll(graphics);
        }

        GfxPrintAllVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paintAll(graphics);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.print(graphics);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paint(graphics);
        }

        GfxPaintVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }
}

