/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class ArithmeticExpr
extends Expr {
    static final int ADD = 0;
    static final int SUBTRACT = 1;
    static final int MULTIPLY = 2;
    static final int DIVIDE = 3;
    static final int MODULO = 4;
    final Expr lhs;
    final Expr rhs;
    final int op;

    ArithmeticExpr(Expr expr, Expr expr2, int n) {
        this.lhs = expr;
        this.rhs = expr2;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.op = n;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object evaluate(Node node2, int n, int n2) {
        Object object = this.lhs.evaluate(node2, n, n2);
        Object object2 = this.rhs.evaluate(node2, n, n2);
        double d = Expr._number(node2, object);
        double d2 = Expr._number(node2, object2);
        switch (this.op) {
            case 0: {
                return new Double(d + d2);
            }
            case 1: {
                return new Double(d - d2);
            }
            case 2: {
                return new Double(d * d2);
            }
            case 3: {
                if (d2 == 0.0 || d2 == -0.0) {
                    if (d == 0.0 || d == -0.0) {
                        return new Double(Double.NaN);
                    }
                    return new Double(d < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                return new Double(d / d2);
            }
            case 4: {
                if (d2 == 0.0 || d2 == 0.0) {
                    if (d == 0.0 || d == -0.0) {
                        return new Double(Double.NaN);
                    }
                    return new Double(d < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                return new Double(d % d2);
            }
        }
        throw new IllegalStateException();
    }

    public Expr clone(Object object) {
        return new ArithmeticExpr(this.lhs.clone(object), this.rhs.clone(object), this.op);
    }

    public boolean references(QName qName) {
        return this.lhs.references(qName) || this.rhs.references(qName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lhs);
        stringBuffer.append(' ');
        switch (this.op) {
            case 0: {
                stringBuffer.append('+');
                break;
            }
            case 1: {
                stringBuffer.append('-');
                break;
            }
            case 2: {
                stringBuffer.append('*');
                break;
            }
            case 3: {
                stringBuffer.append("div");
                break;
            }
            case 4: {
                stringBuffer.append("mod");
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.rhs);
        return stringBuffer.toString();
    }
}

