/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.ClientMechanism;
import gnu.javax.crypto.sasl.anonymous.AnonymousClient;
import gnu.javax.crypto.sasl.crammd5.CramMD5Client;
import gnu.javax.crypto.sasl.plain.PlainClient;
import gnu.javax.crypto.sasl.srp.SRPClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public class ClientFactory
implements SaslClientFactory {
    public static final Set getNames() {
        return Collections.unmodifiableSet(new HashSet(Arrays.asList(ClientFactory.getNamesInternal(null))));
    }

    private static final String[] getNamesInternal(Map map) {
        String[] stringArray = new String[]{"SRP", "CRAM-MD5", "PLAIN", "ANONYMOUS"};
        if (map == null) {
            return stringArray;
        }
        if (ClientFactory.hasPolicy("javax.security.sasl.policy.credentials", map)) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n++]);
        }
        if (ClientFactory.hasPolicy("javax.security.sasl.policy.noplaintext", map)) {
            arrayList.remove("PLAIN");
        }
        if (ClientFactory.hasPolicy("javax.security.sasl.policy.noactive", map)) {
            arrayList.remove("CRAM-MD5");
            arrayList.remove("PLAIN");
        }
        if (ClientFactory.hasPolicy("javax.security.sasl.policy.nodictionary", map)) {
            arrayList.remove("CRAM-MD5");
            arrayList.remove("PLAIN");
        }
        if (ClientFactory.hasPolicy("javax.security.sasl.policy.noanonymous", map)) {
            arrayList.remove("ANONYMOUS");
        }
        if (ClientFactory.hasPolicy("javax.security.sasl.policy.forward", map)) {
            arrayList.remove("CRAM-MD5");
            arrayList.remove("ANONYMOUS");
            arrayList.remove("PLAIN");
        }
        return (String[])arrayList.toArray(new String[0]);
    }

    public static final ClientMechanism getInstance(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim().toUpperCase()).equals("SRP")) {
            return new SRPClient();
        }
        if (string.equals("CRAM-MD5")) {
            return new CramMD5Client();
        }
        if (string.equals("PLAIN")) {
            return new PlainClient();
        }
        if (string.equals("ANONYMOUS")) {
            return new AnonymousClient();
        }
        return null;
    }

    public SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        String string4;
        ClientMechanism clientMechanism = null;
        for (int i = 0; i < stringArray.length && (clientMechanism = ClientFactory.getInstance(string4 = stringArray[i])) == null; ++i) {
        }
        if (clientMechanism != null) {
            HashMap hashMap = new HashMap();
            if (map != null) {
                hashMap.putAll(map);
            }
            hashMap.put("gnu.crypto.sasl.authorisation.ID", string);
            hashMap.put("gnu.crypto.sasl.protocol", string2);
            hashMap.put("gnu.crypto.sasl.server.name", string3);
            hashMap.put("gnu.crypto.sasl.callback.handler", callbackHandler);
            clientMechanism.init(hashMap);
            return clientMechanism;
        }
        throw new SaslException("No supported mechanism found in given mechanism list");
    }

    public String[] getMechanismNames(Map map) {
        return ClientFactory.getNamesInternal(map);
    }

    private static boolean hasPolicy(String string, Map map) {
        return "true".equalsIgnoreCase(String.valueOf(map.get(string)));
    }
}

