/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.java.security.hash.Sha160;
import gnu.javax.crypto.assembly.Assembly;
import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Stage;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import gnu.javax.crypto.cipher.TripleDES;
import gnu.javax.crypto.kwa.BaseKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TripleDESKeyWrap
extends BaseKeyWrappingAlgorithm {
    private static final byte[] DEFAULT_IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private Assembly asm;
    private HashMap asmAttributes;
    private HashMap modeAttributes;
    private Sha160 sha;
    private SecureRandom rnd;

    private /* synthetic */ void finit$() {
        this.asmAttributes = new HashMap();
        this.modeAttributes = new HashMap();
        this.sha = new Sha160();
    }

    public TripleDESKeyWrap() {
        super("kw-tripledes");
        this.finit$();
    }

    protected void engineInit(Map map) throws InvalidKeyException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.kwa.prng");
        IMode iMode = ModeFactory.getInstance("cbc", new TripleDES(), 8);
        Stage stage = Stage.getInstance(iMode, Direction.FORWARD);
        Cascade cascade = new Cascade();
        Object object = cascade.append(stage);
        this.asmAttributes.put(object, this.modeAttributes);
        this.asm = new Assembly();
        this.asm.addPreTransformer(Transformer.getCascadeTransformer(cascade));
        this.modeAttributes.put("gnu.crypto.cipher.key.material", map.get("gnu.crypto.kwa.kek"));
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.FORWARD);
    }

    protected byte[] engineWrap(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        byte[] byArray3;
        if (n2 != 16 && n2 != 24) {
            throw new IllegalArgumentException("Only 2- and 3-key Triple DES keys are alowed");
        }
        byte[] byArray4 = new byte[24];
        if (n2 == 16) {
            System.arraycopy(byArray, n, byArray4, 0, 16);
            System.arraycopy(byArray, n, byArray4, 16, 8);
        } else {
            System.arraycopy(byArray, n, byArray4, 0, 24);
        }
        TripleDES.adjustParity(byArray4, 0);
        this.sha.update(byArray4);
        byte[] byArray5 = this.sha.digest();
        byte[] byArray6 = new byte[8];
        System.arraycopy(byArray5, 0, byArray6, 0, 8);
        byte[] byArray7 = new byte[byArray4.length + byArray6.length];
        System.arraycopy(byArray4, 0, byArray7, 0, byArray4.length);
        System.arraycopy(byArray6, 0, byArray7, byArray4.length, byArray6.length);
        byte[] byArray8 = new byte[8];
        this.nextRandomBytes(byArray8);
        this.modeAttributes.put("gnu.crypto.mode.iv", byArray8);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.FORWARD);
        try {
            this.asm.init(this.asmAttributes);
            byArray3 = this.asm.lastUpdate(byArray7);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        byte[] byArray9 = new byte[byArray8.length + byArray3.length];
        System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
        System.arraycopy(byArray3, 0, byArray9, byArray8.length, byArray3.length);
        byte[] byArray10 = new byte[byArray9.length];
        int n3 = 0;
        int n4 = byArray9.length - 1;
        while (n3 < byArray9.length) {
            byArray10[n4] = byArray9[n3];
            ++n3;
            --n4;
        }
        this.modeAttributes.put("gnu.crypto.mode.iv", DEFAULT_IV);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.FORWARD);
        try {
            this.asm.init(this.asmAttributes);
            byArray2 = this.asm.lastUpdate(byArray10);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        return byArray2;
    }

    protected byte[] engineUnwrap(byte[] byArray, int n, int n2) throws KeyUnwrappingException {
        byte[] byArray2;
        byte[] byArray3;
        if (n2 != 40) {
            throw new IllegalArgumentException("length MUST be 40");
        }
        this.modeAttributes.put("gnu.crypto.mode.iv", DEFAULT_IV);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.REVERSED);
        try {
            this.asm.init(this.asmAttributes);
            byArray3 = this.asm.lastUpdate(byArray, n, 40);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        byte[] byArray4 = new byte[40];
        int n3 = 0;
        int n4 = 39;
        while (n3 < 40) {
            byArray4[n4] = byArray3[n3];
            ++n3;
            --n4;
        }
        byte[] byArray5 = new byte[8];
        byte[] byArray6 = new byte[32];
        System.arraycopy(byArray4, 0, byArray5, 0, 8);
        System.arraycopy(byArray4, 8, byArray6, 0, 32);
        this.modeAttributes.put("gnu.crypto.mode.iv", byArray5);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.REVERSED);
        try {
            this.asm.init(this.asmAttributes);
            byArray2 = this.asm.lastUpdate(byArray6, 0, 32);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        byte[] byArray7 = new byte[24];
        byte[] byArray8 = new byte[8];
        System.arraycopy(byArray2, 0, byArray7, 0, 24);
        System.arraycopy(byArray2, 24, byArray8, 0, 8);
        this.sha.update(byArray7);
        byte[] byArray9 = this.sha.digest();
        byte[] byArray10 = new byte[8];
        System.arraycopy(byArray9, 0, byArray10, 0, 8);
        if (!Arrays.equals(byArray8, byArray10)) {
            throw new KeyUnwrappingException("ICV and computed ICV MUST match");
        }
        if (!TripleDES.isParityAdjusted(byArray7, 0)) {
            throw new KeyUnwrappingException("Triple-DES key parity MUST be adjusted");
        }
        return byArray7;
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }
}

