/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.sig.BaseSignature;
import gnu.java.security.sig.rsa.EMSA_PSS;
import gnu.java.security.sig.rsa.RSA;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Logger;

public class RSAPSSSignature
extends BaseSignature {
    private static final Logger log = Logger.getLogger(RSAPSSSignature.class$("gnu.java.security.sig.rsa.RSAPSSSignature").getName());
    private EMSA_PSS pss;
    private int sLen;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public RSAPSSSignature() {
        this("sha-160", 0);
    }

    public RSAPSSSignature(String string) {
        this(string, 0);
    }

    public RSAPSSSignature(String string, int n) {
        this(HashFactory.getInstance(string), n);
    }

    public RSAPSSSignature(IMessageDigest iMessageDigest, int n) {
        super("rsa-pss", iMessageDigest);
        this.pss = EMSA_PSS.getInstance(iMessageDigest.name());
        this.sLen = n;
    }

    private RSAPSSSignature(RSAPSSSignature rSAPSSSignature) {
        this(rSAPSSSignature.md.name(), rSAPSSSignature.sLen);
        this.publicKey = rSAPSSSignature.publicKey;
        this.privateKey = rSAPSSSignature.privateKey;
        this.md = (IMessageDigest)rSAPSSSignature.md.clone();
        this.pss = (EMSA_PSS)rSAPSSSignature.pss.clone();
    }

    public Object clone() {
        return new RSAPSSSignature(this);
    }

    protected void setupForVerification(PublicKey publicKey) throws IllegalArgumentException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = (RSAPublicKey)publicKey;
    }

    protected void setupForSigning(PrivateKey privateKey) throws IllegalArgumentException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = (RSAPrivateKey)privateKey;
    }

    protected Object generateSignature() throws IllegalStateException {
        int n = ((RSAPrivateKey)this.privateKey).getModulus().bitLength();
        byte[] byArray = new byte[this.sLen];
        this.nextRandomBytes(byArray);
        byte[] byArray2 = this.pss.encode(this.md.digest(), n - 1, byArray);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = RSA.sign(this.privateKey, bigInteger);
        int n2 = (n + 7) / 8;
        return RSA.I2OSP(bigInteger2, n2);
    }

    protected boolean verifySignature(Object object) throws IllegalStateException {
        byte[] byArray;
        if (this.publicKey == null) {
            throw new IllegalStateException();
        }
        byte[] byArray2 = (byte[])object;
        int n = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        int n2 = (n + 7) / 8;
        if (byArray2.length != n2) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = null;
        try {
            bigInteger2 = RSA.verify(this.publicKey, bigInteger);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        int n3 = n - 1;
        int n4 = (n3 + 7) / 8;
        byte[] byArray3 = bigInteger2.toByteArray();
        if (byArray3.length > n4) {
            return false;
        }
        if (byArray3.length < n4) {
            byArray = new byte[n4];
            System.arraycopy(byArray3, 0, byArray, n4 - byArray3.length, byArray3.length);
            byArray3 = byArray;
        }
        byArray = this.md.digest();
        boolean bl = false;
        try {
            bl = this.pss.decode(byArray, byArray3, n3, this.sLen);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }
}

