/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.local;

import gnu.java.net.local.LocalSocketAddress;
import gnu.java.net.local.LocalSocketImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;

public final class LocalSocket
extends Socket {
    private final LocalSocketImpl localimpl;
    boolean localClosed;
    boolean localConnected;

    public LocalSocket() throws SocketException {
        this.localimpl = new LocalSocketImpl();
    }

    public LocalSocket(LocalSocketAddress localSocketAddress) throws SocketException {
        this();
        try {
            this.connect(localSocketAddress);
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    LocalSocket(boolean bl) throws IOException {
        this.localimpl = new LocalSocketImpl(bl);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        throw new SocketException("binding local client sockets is nonsensical");
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(socketAddress instanceof LocalSocketAddress)) {
            throw new IllegalArgumentException("socket address is not a local address");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        try {
            this.localimpl.doCreate();
            this.localimpl.localConnect((LocalSocketAddress)socketAddress);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        this.localConnected = true;
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public int getPort() {
        return -1;
    }

    public int getLocalPort() {
        return -1;
    }

    public SocketChannel getChannel() {
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.localimpl.getLocalAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.localimpl.getRemoteAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.localimpl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.localimpl.getOutputStream();
    }

    public void sendUrgentData(int n) throws IOException {
        this.localimpl.sendUrgentData(n);
    }

    public synchronized void close() throws IOException {
        this.localimpl.close();
        this.localClosed = true;
    }

    public void shutdownInput() throws IOException {
        this.localimpl.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.localimpl.shutdownOutput();
    }

    public boolean isClosed() {
        return this.localClosed;
    }

    public boolean isBound() {
        return false;
    }

    public boolean isConnected() {
        return this.localConnected;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public boolean getTcpNoDelay() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public int getSoLinger() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setOOBInline(boolean bl) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public boolean getOOBInline() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setSoTimeout(int n) throws SocketException {
    }

    public int getSoTimeout() throws SocketException {
        return 0;
    }

    public void setSendBufferSize(int n) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public int getSendBufferSize() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public int getReceiveBufferSize() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public boolean getKeepAlive() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setTrafficClass(int n) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public int getTrafficClass() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    public boolean getReuseAddress() throws SocketException {
        throw new SocketException("local sockets do not support this option");
    }

    LocalSocketImpl getLocalImpl() {
        return this.localimpl;
    }
}

