/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Signature {
    public static String computeClassSignature(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Signature._addToSignature(stringBuffer, clazz);
        return stringBuffer.toString();
    }

    public static String computeFieldSignature(Field field) {
        return Signature.computeClassSignature(field.getType());
    }

    public static String computeMethodSignature(Method method) {
        return Signature._computeSignature(method.getReturnType(), method.getParameterTypes());
    }

    private static String _computeSignature(Class clazz, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Signature._addToSignature(stringBuffer, classArray[i]);
            }
        }
        stringBuffer.append(")");
        Signature._addToSignature(stringBuffer, clazz);
        return stringBuffer.toString();
    }

    private static void _addToSignature(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                stringBuffer.append('V');
            } else if (clazz == Boolean.TYPE) {
                stringBuffer.append('Z');
            } else if (clazz == Byte.TYPE) {
                stringBuffer.append('B');
            } else if (clazz == Character.TYPE) {
                stringBuffer.append('C');
            } else if (clazz == Short.TYPE) {
                stringBuffer.append('S');
            } else if (clazz == Integer.TYPE) {
                stringBuffer.append('I');
            } else if (clazz == Float.TYPE) {
                stringBuffer.append('F');
            } else if (clazz == Double.TYPE) {
                stringBuffer.append('D');
            } else if (clazz == Long.TYPE) {
                stringBuffer.append('J');
            }
            return;
        }
        String string = clazz.getName();
        int n = string.length();
        stringBuffer.ensureCapacity(n);
        if (!clazz.isArray()) {
            stringBuffer.append('L');
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                c = '/';
            }
            stringBuffer.append(c);
        }
        if (!clazz.isArray()) {
            stringBuffer.append(';');
        }
    }
}

