/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ccvs.core.mapping.CVSCheckedInChangeSet;
import org.eclipse.team.internal.ccvs.core.mapping.ChangeSetModelProvider;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetSorter;
import org.eclipse.team.internal.ccvs.ui.mappings.CheckedInChangeSetCollector;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelParticipantChangeSetCapability;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.BatchingChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.internal.ui.mapping.ResourceModelLabelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.internal.navigator.extensions.CommonExtensionSite;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class ChangeSetContentProvider
extends ResourceModelContentProvider
implements ITreePathContentProvider {
    private ResourceDiffTree theRest;
    private IChangeSetChangeListener collectorListener = new CollectorListener();
    private IDiffChangeListener diffTreeListener = new IDiffChangeListener(){

        public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
        }

        public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
            Object input = ChangeSetContentProvider.this.getViewer().getInput();
            if (input instanceof ChangeSetModelProvider && event.getTree() == ChangeSetContentProvider.this.theRest) {
                Utils.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).refresh();
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
        }
    };
    private CheckedInChangeSetCollector checkedInCollector;
    private boolean collectorInitialized;

    protected String getModelProviderId() {
        return "org.eclipse.team.cvs.core.changeSetModel";
    }

    boolean isVisibleInMode(ChangeSet set) {
        Object input = this.getViewer().getInput();
        if (input instanceof ChangeSetModelProvider) {
            if (set instanceof ActiveChangeSet) {
                return this.getConfiguration().getMode() != 1;
            }
            if (set instanceof DiffChangeSet) {
                return this.getConfiguration().getMode() != 2;
            }
        }
        return false;
    }

    protected boolean isEnabled() {
        Object input = this.getViewer().getInput();
        return input instanceof ChangeSetModelProvider;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            return new Object[0];
        }
        if (parent == this.getModelProvider()) {
            return this.getRootElements();
        }
        return super.getElements(parent);
    }

    private Object[] getRootElements() {
        if (!this.collectorInitialized) {
            this.initializeCheckedInChangeSetCollector(this.getChangeSetCapability());
            this.collectorInitialized = true;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        DiffChangeSet[] sets = this.getAllSets();
        int i = 0;
        while (i < sets.length) {
            DiffChangeSet set = sets[i];
            if (this.hasChildren(TreePath.EMPTY.createChildPath((Object)set))) {
                result.add(set);
            }
            ++i;
        }
        ResourceDiffTree tree = this.getTheRest();
        IPath[] otherRoots = tree.getChildren(ResourcesPlugin.getWorkspace().getRoot().getFullPath());
        int i2 = 0;
        while (i2 < otherRoots.length) {
            IPath path = otherRoots[i2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
            if (project.isAccessible() && this.hasChildren(TreePath.EMPTY.createChildPath((Object)project))) {
                result.add(project);
            }
            ++i2;
        }
        return result.toArray();
    }

    private synchronized ResourceDiffTree getTheRest() {
        if (this.theRest == null) {
            this.theRest = new ResourceDiffTree();
            this.theRest.addDiffChangeListener(this.diffTreeListener);
            IResourceDiffTree allChanges = this.getContext().getDiffTree();
            try {
                this.theRest.beginInput();
                allChanges.accept(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new IDiffVisitor(){

                    public boolean visit(IDiff diff) {
                        if (!ChangeSetContentProvider.this.isContainedInSet(diff)) {
                            ChangeSetContentProvider.this.theRest.add(diff);
                        }
                        return true;
                    }
                }, 2);
            }
            finally {
                this.theRest.endInput(null);
            }
        }
        return this.theRest;
    }

    protected boolean isContainedInSet(IDiff diff) {
        DiffChangeSet[] sets = this.getAllSets();
        int i = 0;
        while (i < sets.length) {
            DiffChangeSet set = sets[i];
            if (set.contains(ResourceDiffTree.getResourceFor((IDiff)diff))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        if (object instanceof ChangeSet) {
            ChangeSet set = (ChangeSet)object;
            IResource[] resources = set.getResources();
            return new ResourceTraversal[]{new ResourceTraversal(resources, 0, 0)};
        }
        return super.getTraversals(context, object);
    }

    public Object[] getChildren(TreePath parentPath) {
        ResourceDiffTree diffTree;
        if (!this.isEnabled()) {
            return new Object[0];
        }
        if (parentPath.getSegmentCount() == 0) {
            return this.getRootElements();
        }
        Object first = parentPath.getFirstSegment();
        if (!this.isVisibleInMode(first)) {
            return new Object[0];
        }
        Object parent = parentPath.getLastSegment();
        if (first instanceof DiffChangeSet) {
            DiffChangeSet set = (DiffChangeSet)first;
            diffTree = set.getDiffTree();
            if (parent instanceof DiffChangeSet) {
                parent = this.getModelRoot();
            }
        } else {
            diffTree = this.getTheRest();
            if (parent instanceof ModelProvider) {
                parent = this.getModelRoot();
            }
        }
        Object[] children = this.getChildren(parent);
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (this.isVisible(child, (IResourceDiffTree)diffTree)) {
                result.add(child);
            }
            ++i;
        }
        return result.toArray();
    }

    private boolean isVisibleInMode(Object first) {
        if (first instanceof ChangeSet) {
            ChangeSet cs = (ChangeSet)first;
            int mode = this.getConfiguration().getMode();
            switch (mode) {
                case 4: {
                    return true;
                }
                case 8: {
                    return this.containsConflicts(cs);
                }
                case 1: {
                    return cs instanceof CVSCheckedInChangeSet;
                }
                case 2: {
                    return cs instanceof ActiveChangeSet || this.hasConflicts(cs);
                }
            }
        }
        return true;
    }

    private boolean hasConflicts(ChangeSet cs) {
        if (cs instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)cs;
            return dcs.getDiffTree().countFor(768, 768) > 0L;
        }
        return false;
    }

    private boolean containsConflicts(ChangeSet cs) {
        if (cs instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)cs;
            return dcs.getDiffTree().hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), ResourceModelLabelProvider.CONFLICT_FILTER);
        }
        return false;
    }

    private boolean isVisible(Object object, IResourceDiffTree tree) {
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            IDiff diff = tree.getDiff(resource);
            if (diff != null && this.isVisible(diff)) {
                return true;
            }
            int depth = this.getTraversalCalculator().getLayoutDepth(resource, null);
            IDiff[] diffs = tree.getDiffs(resource, depth);
            int i = 0;
            while (i < diffs.length) {
                IDiff child = diffs[i];
                if (this.isVisible(child)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasChildren(TreePath path) {
        Object first;
        if (path.getSegmentCount() == 1 && (first = path.getFirstSegment()) instanceof ChangeSet) {
            return this.isVisibleInMode(first) && this.hasChildrenInContext((ChangeSet)first);
        }
        return this.getChildren(path).length > 0;
    }

    private boolean hasChildrenInContext(ChangeSet set) {
        IResource[] resources = set.getResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (this.getContext().getDiffTree().getDiff(resource) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TreePath[] getParents(Object element) {
        if (element instanceof ChangeSet) {
            return new TreePath[]{TreePath.EMPTY};
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            DiffChangeSet[] sets = this.getSetsContaining(resource);
            if (sets.length > 0) {
                ArrayList<TreePath> result = new ArrayList<TreePath>();
                int i = 0;
                while (i < sets.length) {
                    DiffChangeSet set = sets[i];
                    TreePath path = this.getPathForElement(set, (IResource)resource.getParent());
                    if (path != null) {
                        result.add(path);
                    }
                    ++i;
                }
                return result.toArray(new TreePath[result.size()]);
            }
            TreePath path = this.getPathForElement((IResourceDiffTree)this.getTheRest(), (IResource)resource.getParent());
            if (path != null) {
                return new TreePath[]{path};
            }
        }
        return new TreePath[0];
    }

    private DiffChangeSet[] getSetsContaining(IResource resource) {
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] allSets = this.getAllSets();
        int i = 0;
        while (i < allSets.length) {
            DiffChangeSet set = allSets[i];
            if (this.isVisible(resource, set.getDiffTree())) {
                result.add(set);
            }
            ++i;
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private DiffChangeSet[] getAllSets() {
        ArrayList<ChangeSet> result = new ArrayList<ChangeSet>();
        ChangeSetCapability csc = this.getChangeSetCapability();
        if (csc.supportsActiveChangeSets()) {
            ActiveChangeSetManager collector = csc.getActiveChangeSetManager();
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                result.add(set);
                ++i;
            }
        }
        if (this.checkedInCollector != null) {
            ChangeSet[] sets = this.checkedInCollector.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                result.add(set);
                ++i;
            }
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private TreePath getPathForElement(IResourceDiffTree tree, IResource resource) {
        List pathList = this.getPath(tree, resource);
        if (pathList != null) {
            TreePath path = new TreePath(pathList.toArray());
            return path;
        }
        return null;
    }

    private TreePath getPathForElement(DiffChangeSet set, IResource resource) {
        List pathList = this.getPath(set.getDiffTree(), resource);
        if (pathList != null) {
            pathList.add(0, set);
            TreePath path = new TreePath(pathList.toArray());
            return path;
        }
        return null;
    }

    private List getPath(IResourceDiffTree tree, IResource resource) {
        boolean hasDiff;
        if (resource == null) {
            return null;
        }
        boolean bl = hasDiff = tree.getDiff(resource) == null;
        if (hasDiff && tree.members(resource).length == 0) {
            return null;
        }
        if (resource.getType() == 8) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(resource.getProject());
        if (resource.getType() != 4) {
            String layout = this.getTraversalCalculator().getLayout();
            if (layout.equals("org.eclipse.team.ui.flay_layout")) {
                result.add(resource);
            } else if (layout.equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2) {
                result.add(resource);
            } else if (layout.equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 1) {
                IContainer parent = resource.getParent();
                if (parent.getType() != 4) {
                    result.add(parent);
                }
                result.add(resource);
            } else {
                ArrayList<IResource> resourcePath = new ArrayList<IResource>();
                IResource next = resource;
                while (next.getType() != 4) {
                    resourcePath.add(next);
                    next = next.getParent();
                }
                int i = resourcePath.size() - 1;
                while (i >= 0) {
                    result.add(resourcePath.get(i));
                    --i;
                }
            }
        }
        return result;
    }

    public void init(ICommonContentExtensionSite site) {
        ChangeSetSorter sorter;
        super.init(site);
        ChangeSetCapability csc = this.getChangeSetCapability();
        if (csc.supportsActiveChangeSets()) {
            ActiveChangeSetManager collector = csc.getActiveChangeSetManager();
            collector.addListener(this.collectorListener);
        }
        if ((sorter = this.getSorter()) != null) {
            sorter.setConfiguration(this.getConfiguration());
        }
    }

    private ChangeSetSorter getSorter() {
        ViewerSorter sorter;
        INavigatorContentService contentService = ((CommonExtensionSite)this.getExtensionSite()).getContentService();
        INavigatorSorterService sortingService = contentService.getSorterService();
        INavigatorContentExtension extension = this.getExtensionSite().getExtension();
        if (extension != null && (sorter = sortingService.findSorter(extension.getDescriptor(), (Object)this.getModelProvider(), (Object)new DiffChangeSet(), (Object)new DiffChangeSet())) instanceof ChangeSetSorter) {
            return (ChangeSetSorter)sorter;
        }
        return null;
    }

    private void initializeCheckedInChangeSetCollector(ChangeSetCapability csc) {
        if (csc.supportsCheckedInChangeSets()) {
            this.checkedInCollector = ((ModelParticipantChangeSetCapability)csc).createCheckedInChangeSetCollector(this.getConfiguration());
            this.getConfiguration().setProperty("org.eclipse.team.cvs.ui.CVSCheckedInCollector", (Object)this.checkedInCollector);
            this.checkedInCollector.addListener(this.collectorListener);
            this.checkedInCollector.add(((ResourceDiffTree)this.getContext().getDiffTree()).getDiffs());
        }
    }

    public void dispose() {
        ChangeSetCapability csc = this.getChangeSetCapability();
        if (csc.supportsActiveChangeSets()) {
            csc.getActiveChangeSetManager().removeListener(this.collectorListener);
        }
        if (this.checkedInCollector != null) {
            this.checkedInCollector.removeListener(this.collectorListener);
            this.checkedInCollector.dispose();
        }
        if (this.theRest != null) {
            this.theRest.removeDiffChangeListener(this.diffTreeListener);
        }
        super.dispose();
    }

    public boolean isVisible(IDiff diff) {
        return super.isVisible(diff);
    }

    public IResourceDiffTree getDiffTree(TreePath path) {
        Object first;
        if (path.getSegmentCount() > 0 && (first = path.getFirstSegment()) instanceof DiffChangeSet) {
            DiffChangeSet set = (DiffChangeSet)first;
            return set.getDiffTree();
        }
        return this.getTheRest();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IPath[] removed = event.getRemovals();
        IDiff[] added = event.getAdditions();
        IDiff[] changed = event.getChanges();
        try {
            IDiff diff;
            this.getTheRest().beginInput();
            int i = 0;
            while (i < removed.length) {
                IPath path = removed[i];
                this.getTheRest().remove(path);
                ++i;
            }
            i = 0;
            while (i < added.length) {
                diff = added[i];
                if (!this.isContainedInSet(diff)) {
                    this.getTheRest().add(diff);
                }
                ++i;
            }
            i = 0;
            while (i < changed.length) {
                diff = changed[i];
                if (this.getTheRest().getDiff(diff.getPath()) != null) {
                    this.getTheRest().add(diff);
                }
                ++i;
            }
        }
        finally {
            this.getTheRest().endInput(monitor);
        }
        if (this.checkedInCollector != null) {
            this.checkedInCollector.handleChange(event);
        }
    }

    protected void updateLabels(ISynchronizationContext context, IPath[] paths) {
        super.updateLabels(context, paths);
        Object[] sets = this.getSetsShowingPropogatedStateFrom(paths);
        if (sets.length > 0) {
            ((AbstractTreeViewer)this.getViewer()).update(sets, null);
        }
    }

    private ChangeSet[] getSetsShowingPropogatedStateFrom(IPath[] paths) {
        HashSet<DiffChangeSet> result = new HashSet<DiffChangeSet>();
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            DiffChangeSet[] sets = this.getSetsShowingPropogatedStateFrom(path);
            int j = 0;
            while (j < sets.length) {
                DiffChangeSet set = sets[j];
                result.add(set);
                ++j;
            }
            ++i;
        }
        return result.toArray(new ChangeSet[result.size()]);
    }

    protected DiffChangeSet[] getSetsShowingPropogatedStateFrom(IPath path) {
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] allSets = this.getAllSets();
        int i = 0;
        while (i < allSets.length) {
            DiffChangeSet set = allSets[i];
            if (set.getDiffTree().getDiff(path) != null || set.getDiffTree().getChildren(path).length > 0) {
                result.add(set);
            }
            ++i;
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.getConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)participant;
            return provider.getChangeSetCapability();
        }
        return null;
    }

    private Set getVisibleSetsInViewer() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<ChangeSet> result = new HashSet<ChangeSet>();
        int i = 0;
        while (i < children.length) {
            TreeItem control = children[i];
            Object data = control.getData();
            if (data instanceof ChangeSet) {
                ChangeSet set = (ChangeSet)data;
                result.add(set);
            }
            ++i;
        }
        return result;
    }

    private final class CollectorListener
    implements IChangeSetChangeListener,
    BatchingChangeSetManager.IChangeSetCollectorChangeListener {
        private CollectorListener() {
        }

        public void setAdded(final ChangeSet set) {
            if (set instanceof ActiveChangeSet) {
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    Utils.syncExec((Runnable)new Runnable(){

                        public void run() {
                            Object input = ChangeSetContentProvider.this.getViewer().getInput();
                            ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(input, (Object)set);
                        }
                    }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
                }
                this.handleSetAddition(set);
            }
        }

        private void handleSetAddition(ChangeSet set) {
            IResource[] resources = set.getResources();
            try {
                ChangeSetContentProvider.this.getTheRest().beginInput();
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    ChangeSetContentProvider.this.getTheRest().remove(resource);
                    ++i;
                }
            }
            finally {
                ChangeSetContentProvider.this.getTheRest().endInput(null);
            }
        }

        public void defaultSetChanged(final ChangeSet previousDefault, final ChangeSet set) {
            if (ChangeSetContentProvider.this.isVisibleInMode(set) || ChangeSetContentProvider.this.isVisibleInMode(previousDefault)) {
                Utils.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).update(new Object[]{previousDefault, set}, null);
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
        }

        public void setRemoved(final ChangeSet set) {
            if (set instanceof ActiveChangeSet) {
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    Utils.syncExec((Runnable)new Runnable(){

                        public void run() {
                            ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove((Object)TreePath.EMPTY.createChildPath((Object)set));
                        }
                    }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
                }
                this.handleSetRemoval(set);
            }
        }

        private void handleSetRemoval(ChangeSet set) {
            IResource[] resources = set.getResources();
            try {
                ChangeSetContentProvider.this.getTheRest().beginInput();
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    IDiff diff = ChangeSetContentProvider.this.getContext().getDiffTree().getDiff(resource);
                    if (diff != null && !ChangeSetContentProvider.this.isContainedInSet(diff)) {
                        ChangeSetContentProvider.this.getTheRest().add(diff);
                    }
                    ++i;
                }
            }
            finally {
                ChangeSetContentProvider.this.getTheRest().endInput(null);
            }
        }

        public void nameChanged(final ChangeSet set) {
            if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                Utils.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).update((Object)set, null);
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
        }

        public void resourcesChanged(final ChangeSet set, IPath[] paths) {
            if (set instanceof ActiveChangeSet) {
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    Utils.syncExec((Runnable)new Runnable(){

                        public void run() {
                            if (ChangeSetContentProvider.this.hasChildrenInContext(set)) {
                                if (ChangeSetContentProvider.this.getVisibleSetsInViewer().contains(set)) {
                                    ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).refresh((Object)set, true);
                                } else {
                                    ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(ChangeSetContentProvider.this.getViewer().getInput(), (Object)set);
                                }
                            } else {
                                ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove((Object)set);
                            }
                        }
                    }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
                }
                this.handleSetChange(set, paths);
            }
        }

        private void handleSetChange(ChangeSet set, IPath[] paths) {
            try {
                ChangeSetContentProvider.this.getTheRest().beginInput();
                int i = 0;
                while (i < paths.length) {
                    IDiff diff;
                    IPath path = paths[i];
                    boolean isContained = ((DiffChangeSet)set).contains(path);
                    if (isContained) {
                        diff = ((DiffChangeSet)set).getDiffTree().getDiff(path);
                        if (diff != null) {
                            ChangeSetContentProvider.this.getTheRest().remove(ResourceDiffTree.getResourceFor((IDiff)diff));
                        }
                    } else {
                        diff = ChangeSetContentProvider.this.getContext().getDiffTree().getDiff(path);
                        if (diff != null && !ChangeSetContentProvider.this.isContainedInSet(diff)) {
                            ChangeSetContentProvider.this.getTheRest().add(diff);
                        }
                    }
                    ++i;
                }
            }
            finally {
                ChangeSetContentProvider.this.getTheRest().endInput(null);
            }
        }

        public void changeSetChanges(BatchingChangeSetManager.CollectorChangeEvent event, IProgressMonitor monitor) {
            ChangeSet[] addedSets = event.getAddedSets();
            final ChangeSet[] visibleAddedSets = this.getVisibleSets(addedSets);
            ChangeSet[] removedSets = event.getRemovedSets();
            final ChangeSet[] visibleRemovedSets = this.getVisibleSets(removedSets);
            ChangeSet[] changedSets = event.getChangedSets();
            final ChangeSet[] visibleChangedSets = this.getVisibleSets(changedSets);
            if (visibleAddedSets.length > 0 || visibleRemovedSets.length > 0 || visibleChangedSets.length > 0) {
                Utils.syncExec((Runnable)new Runnable(){

                    public void run() {
                        try {
                            ChangeSetContentProvider.this.getViewer().getControl().setRedraw(false);
                            if (visibleAddedSets.length > 0) {
                                Object input = ChangeSetContentProvider.this.getViewer().getInput();
                                ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(input, (Object[])visibleAddedSets);
                            }
                            if (visibleRemovedSets.length > 0) {
                                ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove((Object[])visibleRemovedSets);
                            }
                            int i = 0;
                            while (i < visibleChangedSets.length) {
                                ChangeSet set = visibleChangedSets[i];
                                ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).refresh((Object)set, true);
                                ++i;
                            }
                        }
                        finally {
                            ChangeSetContentProvider.this.getViewer().getControl().setRedraw(true);
                        }
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
            try {
                ChangeSet set;
                ChangeSetContentProvider.this.getTheRest().beginInput();
                int i = 0;
                while (i < addedSets.length) {
                    set = addedSets[i];
                    this.handleSetAddition(set);
                    ++i;
                }
                i = 0;
                while (i < removedSets.length) {
                    set = removedSets[i];
                    this.handleSetRemoval(set);
                    ++i;
                }
                i = 0;
                while (i < changedSets.length) {
                    set = changedSets[i];
                    IPath[] paths = event.getChangesFor(set);
                    if (event.getSource().contains(set)) {
                        this.handleSetChange(set, paths);
                    } else {
                        try {
                            ChangeSetContentProvider.this.getTheRest().beginInput();
                            int j = 0;
                            while (j < paths.length) {
                                IPath path = paths[j];
                                IDiff diff = ChangeSetContentProvider.this.getContext().getDiffTree().getDiff(path);
                                if (diff != null && !ChangeSetContentProvider.this.isContainedInSet(diff)) {
                                    ChangeSetContentProvider.this.getTheRest().add(diff);
                                }
                                ++j;
                            }
                        }
                        finally {
                            ChangeSetContentProvider.this.getTheRest().endInput(null);
                        }
                    }
                    ++i;
                }
            }
            finally {
                ChangeSetContentProvider.this.getTheRest().endInput(monitor);
            }
        }

        private ChangeSet[] getVisibleSets(ChangeSet[] sets) {
            ArrayList<ChangeSet> result = new ArrayList<ChangeSet>(sets.length);
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    result.add(set);
                }
                ++i;
            }
            return result.toArray(new ChangeSet[result.size()]);
        }
    }
}

