/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.util.ArrayList;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.data.AbstractSubItem;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.IExecutableItem;
import org.eclipse.ui.internal.cheatsheets.data.IPerformWhenItem;
import org.eclipse.ui.internal.cheatsheets.data.ISubItemItem;
import org.eclipse.ui.internal.cheatsheets.data.Intro;
import org.eclipse.ui.internal.cheatsheets.data.PerformWhen;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;

public class Item
extends Intro
implements IExecutableItem,
IPerformWhenItem,
ISubItemItem {
    private String title;
    private boolean skip;
    private boolean dialog;
    private ArrayList itemExtensions;
    private AbstractExecutable executable;
    private PerformWhen performWhen;
    private ArrayList subItems;
    private String completionMessage;

    public Item() {
    }

    public Item(String title, String description, String href, String contextId, boolean skip, boolean dialog) {
        super(description, href, contextId);
        this.title = title;
        this.skip = skip;
        this.dialog = dialog;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDynamic() {
        return this.performWhen != null || this.hasDynamicSubItems();
    }

    public boolean isDialog() {
        return this.dialog;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setDialog(boolean dialog) {
        this.dialog = dialog;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setItemExtensions(ArrayList exts) {
        this.itemExtensions = exts;
    }

    public ArrayList getItemExtensions() {
        return this.itemExtensions;
    }

    public PerformWhen getPerformWhen() {
        return this.performWhen;
    }

    public void setPerformWhen(PerformWhen performWhen) {
        this.performWhen = performWhen;
    }

    public void addSubItem(AbstractSubItem subItem) {
        if (this.subItems == null) {
            this.subItems = new ArrayList();
        }
        this.subItems.add(subItem);
    }

    public ArrayList getSubItems() {
        return this.subItems;
    }

    private boolean hasDynamicSubItems() {
        if (this.subItems != null) {
            for (AbstractSubItem subItem : this.subItems) {
                if (!(subItem instanceof RepeatedSubItem) && !(subItem instanceof ConditionalSubItem) && (!(subItem instanceof SubItem) || ((SubItem)subItem).getPerformWhen() == null)) continue;
                return true;
            }
        }
        return false;
    }

    public AbstractExecutable getExecutable() {
        return this.executable;
    }

    public void setExecutable(AbstractExecutable executable) {
        this.executable = executable;
    }

    public void setCompletionMessage(String message) {
        this.completionMessage = message;
    }

    public String getCompletionMessage() {
        return this.completionMessage;
    }
}

