/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.text.XMLProblemAnnotation;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.ant.internal.ui.model.IProblemRequestor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class AntAnnotationModel
extends ResourceMarkerAnnotationModel
implements IProblemRequestor {
    private List fGeneratedAnnotations = new ArrayList();
    private List fCollectedProblems = new ArrayList();

    public AntAnnotationModel(IFile file) {
        super((IResource)file);
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
        if ("org.eclipse.ant.ui.buildFileProblem".equals(markerType)) {
            return null;
        }
        return new MarkerAnnotation(EditorsUI.getAnnotationTypeLookup().getAnnotationType(marker), marker);
    }

    protected Position createPositionFromProblem(IProblem problem) {
        int length;
        int start = problem.getOffset();
        if (start >= 0 && (length = problem.getLength()) >= 0) {
            return new Position(start, length);
        }
        return null;
    }

    public void acceptProblem(IProblem problem) {
        this.fCollectedProblems.add(problem);
    }

    public void beginReporting() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReporting() {
        boolean temporaryProblemsChanged = false;
        IAnnotationMap iAnnotationMap = this.getAnnotationMap();
        synchronized (iAnnotationMap) {
            if (this.fGeneratedAnnotations.size() > 0) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                for (IProblem problem : this.fCollectedProblems) {
                    Position position = this.createPositionFromProblem(problem);
                    if (position == null) continue;
                    XMLProblemAnnotation annotation = new XMLProblemAnnotation(problem);
                    this.fGeneratedAnnotations.add(annotation);
                    try {
                        this.addAnnotation(annotation, position, false);
                    }
                    catch (BadLocationException ex) {
                        AntUIPlugin.log(ex);
                    }
                    temporaryProblemsChanged = true;
                }
                this.fCollectedProblems.clear();
            }
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
        }
    }

    protected boolean isAcceptable(IMarker marker) {
        if (super.isAcceptable(marker)) {
            return !marker.getAttribute("org.eclipse.ant.ui.runToLineBreakpoint", false);
        }
        return false;
    }
}

