/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.osgi.framework.Bundle;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map imageDescriptors;
    private static Image[] busyImages;
    private static final String URL_PREFIX = "$nl$/icons/";
    private static final String URL_CLCL = "$nl$/icons/clcl16/";
    private static final String URL_ELCL = "$nl$/icons/elcl16/";
    private static final String URL_DLCL = "$nl$/icons/dlcl16/";
    private static final String URL_OBJ = "$nl$/icons/obj16/";
    public static final String IMG_CLCL_NAV_BACKWARD = "IMG_CLCL_NAV_BACKWARD";
    public static final String IMG_CLCL_NAV_FORWARD = "IMG_CLCL_NAV_FORWARD";
    public static final String IMG_CLCL_NAV_STOP = "IMG_CLCL_NAV_STOP";
    public static final String IMG_CLCL_NAV_REFRESH = "IMG_CLCL_NAV_REFRESH";
    public static final String IMG_CLCL_NAV_GO = "IMG_CLCL_NAV_GO";
    public static final String IMG_CLCL_NAV_HOME = "IMG_CLCL_NAV_HOME";
    public static final String IMG_CLCL_NAV_PRINT = "IMG_CLCL_NAV_PRINT";
    public static final String IMG_ELCL_NAV_BACKWARD = "IMG_ELCL_NAV_BACKWARD";
    public static final String IMG_ELCL_NAV_FORWARD = "IMG_ELCL_NAV_FORWARD";
    public static final String IMG_ELCL_NAV_STOP = "IMG_ELCL_NAV_STOP";
    public static final String IMG_ELCL_NAV_REFRESH = "IMG_ELCL_NAV_REFRESH";
    public static final String IMG_ELCL_NAV_GO = "IMG_ELCL_NAV_GO";
    public static final String IMG_ELCL_NAV_HOME = "IMG_ELCL_NAV_HOME";
    public static final String IMG_ELCL_NAV_PRINT = "IMG_ELCL_NAV_PRINT";
    public static final String IMG_DLCL_NAV_BACKWARD = "IMG_DLCL_NAV_BACKWARD";
    public static final String IMG_DLCL_NAV_FORWARD = "IMG_DLCL_NAV_FORWARD";
    public static final String IMG_DLCL_NAV_STOP = "IMG_DLCL_NAV_STOP";
    public static final String IMG_DLCL_NAV_REFRESH = "IMG_DLCL_NAV_REFRESH";
    public static final String IMG_DLCL_NAV_GO = "IMG_DLCL_NAV_GO";
    public static final String IMG_DLCL_NAV_HOME = "IMG_DLCL_NAV_HOME";
    public static final String IMG_DLCL_NAV_PRINT = "IMG_DLCL_NAV_PRINT";
    public static final String IMG_INTERNAL_BROWSER = "internalBrowser";
    public static final String IMG_EXTERNAL_BROWSER = "externalBrowser";
    public static final String IMG_SYSTEM_BROWSER = "systemBrowser";

    private ImageResource() {
    }

    public static Image[] getBusyImages() {
        return busyImages;
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return (ImageDescriptor)imageDescriptors.get(key);
    }

    protected static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap();
        ImageResource.registerImage(IMG_ELCL_NAV_BACKWARD, "$nl$/icons/elcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_FORWARD, "$nl$/icons/elcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_STOP, "$nl$/icons/elcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_REFRESH, "$nl$/icons/elcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_GO, "$nl$/icons/elcl16/nav_go.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_HOME, "$nl$/icons/elcl16/nav_home.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_PRINT, "$nl$/icons/elcl16/nav_print.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_BACKWARD, "$nl$/icons/clcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_FORWARD, "$nl$/icons/clcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_STOP, "$nl$/icons/clcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_REFRESH, "$nl$/icons/clcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_GO, "$nl$/icons/clcl16/nav_go.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_HOME, "$nl$/icons/clcl16/nav_home.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_PRINT, "$nl$/icons/clcl16/nav_print.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_BACKWARD, "$nl$/icons/dlcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_FORWARD, "$nl$/icons/dlcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_STOP, "$nl$/icons/dlcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_REFRESH, "$nl$/icons/dlcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_GO, "$nl$/icons/dlcl16/nav_go.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_HOME, "$nl$/icons/dlcl16/nav_home.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_PRINT, "$nl$/icons/dlcl16/nav_print.gif");
        ImageResource.registerImage(IMG_INTERNAL_BROWSER, "$nl$/icons/obj16/internal_browser.gif");
        ImageResource.registerImage(IMG_EXTERNAL_BROWSER, "$nl$/icons/obj16/external_browser.gif");
        busyImages = new Image[13];
        int i = 0;
        while (i < 13) {
            ImageResource.registerImage("busy" + i, "$nl$/icons/obj16/busy/" + (i + 1) + ".gif");
            ImageResource.busyImages[i] = ImageResource.getImage("busy" + i);
            ++i;
        }
    }

    private static void registerImage(String key, String partialURL) {
        try {
            URL url = FileLocator.find((Bundle)WebBrowserUIPlugin.getInstance().getBundle(), (IPath)new Path(partialURL), null);
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error registering image " + key + " from " + partialURL, e);
        }
    }
}

