/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ProblemTreeViewer
extends TreeViewer
implements ResourceToItemsMapper.IContentViewerAccessor {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTreeViewer(Composite parent) {
        super(parent);
        this.initMapper();
    }

    public ProblemTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initMapper();
    }

    public ProblemTreeViewer(Tree tree) {
        super(tree);
        this.initMapper();
    }

    public void doUpdateItem(Widget item) {
        this.doUpdateItem(item, item.getData(), true);
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper(this);
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fResourceToItemsMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element, item);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
        if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
            return;
        }
        Object[] changed = this.addAditionalProblemParents(event.getElements());
        if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                if (curr instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                } else {
                    others.add(curr);
                }
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        } else if (event.getElements() != changed) {
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), changed);
        }
        super.handleLabelProviderChanged(event);
    }

    private boolean canIgnoreChangesFromAnnotionModel() {
        IContentProvider contentProvider = this.getContentProvider();
        return contentProvider instanceof IWorkingCopyProvider && !((IWorkingCopyProvider)contentProvider).providesWorkingCopies();
    }

    protected boolean evaluateExpandableWithFilters(Object parent) {
        return parent instanceof IMember;
    }

    public boolean isExpandable(Object parent) {
        if (this.hasFilters() && this.evaluateExpandableWithFilters(parent)) {
            Object[] children = this.getRawChildren(parent);
            if (children.length > 0) {
                ViewerFilter[] filters = this.getFilters();
                int i = 0;
                while (i < children.length) {
                    if (!this.isFiltered(children[i], parent, filters)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return super.isExpandable(parent);
    }

    protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (!filter.select((Viewer)this, parent, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Object[] addAditionalProblemParents(Object[] elements) {
        return elements;
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        if (!invalidSelection.isEmpty() && newSelection.isEmpty() && invalidSelection instanceof ITreeSelection) {
            newSelection = new StructuredSelection(((IStructuredSelection)invalidSelection).toArray());
            this.setSelection(newSelection);
        }
        super.handleInvalidSelection(invalidSelection, newSelection);
    }
}

