/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public final class FacetCorePlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.project.facet.core";
    private static final String TRACING_ACTION_SORTING = "org.eclipse.wst.common.project.facet.core/actionSorting";
    private static final String TRACING_FRAMEWORK_ACTIVATION = "org.eclipse.wst.common.project.facet.core/activation";
    private static final Set messagesLogged = new HashSet();
    private static final ILog platformLog = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.wst.common.project.facet.core"));

    public static boolean isTracingActionSorting() {
        return FacetCorePlugin.checkDebugOption(TRACING_ACTION_SORTING);
    }

    public static boolean isTracingFrameworkActivation() {
        return FacetCorePlugin.checkDebugOption(TRACING_FRAMEWORK_ACTIVATION);
    }

    private static boolean checkDebugOption(String debugOption) {
        String optionValue = Platform.getDebugOption((String)debugOption);
        return optionValue == null ? false : Boolean.valueOf(optionValue).equals(Boolean.TRUE);
    }

    public static void log(Exception e) {
        String msg = String.valueOf(e.getMessage());
        FacetCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        platformLog.log(status);
    }

    public static void log(String msg) {
        FacetCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void logError(String msg) {
        FacetCorePlugin.logError(msg, false);
    }

    public static void logError(String msg, boolean suppressDuplicates) {
        if (suppressDuplicates && messagesLogged.contains(msg)) {
            return;
        }
        messagesLogged.add(msg);
        FacetCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void logWarning(String msg) {
        FacetCorePlugin.logWarning(msg, false);
    }

    public static void logWarning(String msg, boolean suppressDuplicates) {
        if (suppressDuplicates && messagesLogged.contains(msg)) {
            return;
        }
        messagesLogged.add(msg);
        FacetCorePlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, msg, null));
    }

    public static IStatus createErrorStatus(String msg) {
        return FacetCorePlugin.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, 0, msg, (Throwable)e);
    }

    public static Object instantiate(String pluginId, String clname, Class interfc) throws CoreException {
        Object obj;
        Bundle bundle = Platform.getBundle((String)pluginId);
        try {
            Class cl = bundle.loadClass(clname);
            obj = cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToCreate, (Object)clname);
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg, e));
        }
        if (!interfc.isAssignableFrom(obj.getClass())) {
            String msg = NLS.bind((String)Resources.doesNotImplement, (Object)clname, (Object)interfc.getClass().getName());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        return obj;
    }

    private static final class Resources
    extends NLS {
        public static String failedToCreate;
        public static String doesNotImplement;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

