/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class DialogArea {
    protected static final int LABEL_WIDTH_HINT = 400;
    protected Dialog parentDialog;
    protected FontMetrics fontMetrics;
    protected IDialogSettings settings;
    protected List listeners = new ArrayList();

    public DialogArea(Dialog parentDialog, IDialogSettings settings) {
        this.parentDialog = parentDialog;
        this.settings = settings;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChangeChange(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)iter.next();
            listener.propertyChange(event);
        }
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    public abstract Control createArea(Composite var1);

    protected Shell getShell() {
        if (this.parentDialog == null) {
            return Display.getCurrent().getActiveShell();
        }
        return this.parentDialog.getShell();
    }

    protected Button createCheckbox(Composite parent, String label, int span) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createButton(Composite parent, String label, int style) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData(style);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Label createWrappingLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Composite createGrabbingComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        return composite;
    }
}

