/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.repository.Repository;
import fr.jayasoft.ivy.repository.Resource;
import java.io.File;

public class TransferEvent
extends IvyEvent {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    public static final String TRANSFER_INITIATED_NAME = "transfer-initiated";
    public static final String TRANSFER_STARTED_NAME = "transfer-started";
    public static final String TRANSFER_PROGRESS_NAME = "transfer-progress";
    public static final String TRANSFER_COMPLETED_NAME = "transfer-completed";
    public static final String TRANSFER_ERROR_NAME = "transfer-error";
    private Resource _resource;
    private int _eventType;
    private int _requestType;
    private Exception _exception;
    private File _localFile;
    private Repository _repository;
    private long _length;
    private long _totalLength;
    private boolean _isTotalLengthSet = false;

    public TransferEvent(Ivy ivy, Repository repository, Resource resource, int eventType, int requestType) {
        super(ivy, TransferEvent.getName(eventType));
        this._repository = repository;
        this.addAttribute("repository", this._repository.getName());
        this._resource = resource;
        this.addAttribute("resource", this._resource.getName());
        this.setEventType(eventType);
        this.setRequestType(requestType);
        this.addAttribute("request-type", requestType == 5 ? "get" : "put");
    }

    public TransferEvent(Ivy ivy, Repository repository, Resource resource, Exception exception, int requestType) {
        this(ivy, repository, resource, 4, requestType);
        this._exception = exception;
    }

    public TransferEvent(Ivy ivy, Repository repository, Resource resource, long length, int requestType) {
        this(ivy, repository, resource, 3, requestType);
        this._length = length;
        this._totalLength = length;
    }

    private static String getName(int eventType) {
        switch (eventType) {
            case 0: {
                return TRANSFER_INITIATED_NAME;
            }
            case 1: {
                return TRANSFER_STARTED_NAME;
            }
            case 3: {
                return TRANSFER_PROGRESS_NAME;
            }
            case 2: {
                return TRANSFER_COMPLETED_NAME;
            }
            case 4: {
                return TRANSFER_ERROR_NAME;
            }
        }
        return null;
    }

    public Resource getResource() {
        return this._resource;
    }

    public Exception getException() {
        return this._exception;
    }

    public int getRequestType() {
        return this._requestType;
    }

    protected void setRequestType(int requestType) {
        switch (requestType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + requestType);
            }
        }
        this._requestType = requestType;
    }

    public int getEventType() {
        return this._eventType;
    }

    protected void setEventType(int eventType) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal event type: " + eventType);
            }
        }
        this._eventType = eventType;
    }

    protected void setResource(Resource resource) {
        this._resource = resource;
    }

    public File getLocalFile() {
        return this._localFile;
    }

    protected void setLocalFile(File localFile) {
        this._localFile = localFile;
    }

    public long getLength() {
        return this._length;
    }

    protected void setLength(long length) {
        this._length = length;
    }

    public long getTotalLength() {
        return this._totalLength;
    }

    protected void setTotalLength(long totalLength) {
        this._totalLength = totalLength;
    }

    public void setException(Exception exception) {
        this._exception = exception;
    }

    public boolean isTotalLengthSet() {
        return this._isTotalLengthSet;
    }

    public void setTotalLengthSet(boolean isTotalLengthSet) {
        this._isTotalLengthSet = isTotalLengthSet;
    }
}

