/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.epic.debug.PerlBreakpoint;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;
import org.epic.debug.db.PerlDB;

public class PerlBreakpointManager
implements IBreakpointListener {
    private final Set debuggers = new HashSet();

    public PerlBreakpointManager() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public void addDebugger(PerlDB db) {
        this.debuggers.add(db);
        IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PerlDebugPlugin.getUniqueIdentifier());
        int i = 0;
        while (i < bps.length) {
            PerlBreakpoint bp = (PerlBreakpoint)bps[i];
            try {
                if (bp.isEnabled()) {
                    db.addBreakpoint(bp);
                    bp.addDebugger(db);
                }
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
            }
            ++i;
        }
    }

    public void breakpointAdded(IBreakpoint fBreakpoint) {
        if (!(fBreakpoint instanceof PerlBreakpoint)) {
            return;
        }
        PerlBreakpoint bp = (PerlBreakpoint)fBreakpoint;
        try {
            if (!bp.isEnabled()) {
                return;
            }
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return;
        }
        Iterator i = this.debuggers.iterator();
        while (i.hasNext()) {
            PerlDB db = (PerlDB)i.next();
            try {
                db.addBreakpoint(bp);
                bp.addDebugger(db);
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!(breakpoint instanceof PerlBreakpoint)) {
            return;
        }
        PerlBreakpoint bp = (PerlBreakpoint)breakpoint;
        PerlDB[] debuggers = bp.getDebuggers();
        int i = 0;
        while (i < debuggers.length) {
            PerlDB db = debuggers[i];
            try {
                db.removeBreakpoint(bp);
                bp.removeDebugger(db);
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
            }
            ++i;
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!(breakpoint instanceof PerlLineBreakpoint)) {
            return;
        }
        boolean enabledOld = (Boolean)delta.getAttribute("org.eclipse.debug.core.enabled");
        boolean enabledNew = false;
        try {
            enabledNew = (Boolean)breakpoint.getMarker().getAttribute("org.eclipse.debug.core.enabled");
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return;
        }
        if (enabledOld != enabledNew) {
            if (enabledNew) {
                this.breakpointAdded(breakpoint);
            } else {
                this.breakpointRemoved(breakpoint, delta);
            }
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
    }

    public Set getDebuggers() {
        return Collections.unmodifiableSet(this.debuggers);
    }

    public void removeDebugger(PerlDB db) {
        this.debuggers.remove(db);
        IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PerlDebugPlugin.getUniqueIdentifier());
        int i = 0;
        while (i < bps.length) {
            ((PerlBreakpoint)bps[i]).removeDebugger(db);
            ++i;
        }
    }
}

