/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVImport;
import com.darwinsys.csv.CSVParser;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public abstract class CSVParserTestBase
extends TestCase {
    CSVParser csv;
    X[] data = new X[]{new X(1, "abc"), new X(2, "hello, world"), new X(3, "a,b,c"), new X(3, "a\"bc,d,e"), new X(3, "\"a,a\",b,\"c:\\foo\\bar\""), new X(1, "\"he\"llo"), new X(2, "123,456"), new X(5, "\"LU\",86.25,\"11/4/1998\",\"2:19PM\",+4.0625"), new X(2, "bad \"input\",123e01")};

    public void testCSV() throws Throwable {
        if (this.csv == null) {
            throw new IllegalArgumentException("csv parser not created");
        }
        int i = 0;
        try {
            i = 0;
            while (i < this.data.length) {
                List<String> l = this.csv.parse(this.data[i].input);
                CSVParserTestBase.assertEquals((int)this.data[i].expectLength, (int)l.size());
                int k = 0;
                while (k < l.size()) {
                    System.out.print("[" + l.get(k) + "],");
                    ++k;
                }
                System.out.println();
                ++i;
            }
        }
        catch (Throwable t) {
            System.err.printf("Error occured in data[%d], %s%n", i, this.data[i].expectLength);
            throw t;
        }
    }

    public void testBarDelim() {
        CSVImport parser = new CSVImport('|');
        List<String> l = parser.parse("\"LU\"|86.25|\"11/4/1998\"|\"2:19PM\"|+4.0625");
        CSVParserTestBase.assertEquals((int)l.size(), (int)5);
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            System.out.print("[" + it.next() + "],");
        }
        System.out.println();
    }

    class X {
        int expectLength;
        String input;

        public X(int expectLength, String input) {
            this.expectLength = expectLength;
            this.input = input;
        }
    }
}

