/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.ColumnEditPanel;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditColumnAction
extends AbstractAction
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(EditColumnAction.class);
    protected PlayPen pp;
    protected DBTree dbt;
    protected JDialog editDialog;
    protected ColumnEditPanel columnEditPanel;

    public EditColumnAction() {
        super("Column Properties...", ASUtils.createIcon("ColumnProperties", "Column Properties", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Column Properties");
        this.putValue("ActionCommandKey", "PlayPen");
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent evt) {
        block20: {
            if (evt.getActionCommand().equals("PlayPen")) {
                List<PlayPenComponent> selection = this.pp.getSelectedItems();
                logger.debug((Object)("selections length is: " + selection.size()));
                if (selection.size() < 1) {
                    this.setEnabled(false);
                    JOptionPane.showMessageDialog(this.pp, "Select a column (by clicking on it) and try again.");
                } else if (selection.size() > 1) {
                    JOptionPane.showMessageDialog(this.pp, "You have selected multiple items, but you can only edit one at a time.");
                } else if (selection.get(0) instanceof TablePane) {
                    this.setEnabled(true);
                    TablePane tp = (TablePane)selection.get(0);
                    try {
                        List<SQLColumn> selectedCols = tp.getSelectedColumns();
                        if (selectedCols.size() != 1) {
                            JOptionPane.showMessageDialog(this.pp, "Please select one and only one column");
                            logger.error((Object)"Please select one and only one column");
                            this.cleanup();
                            return;
                        }
                        int idx = tp.getSelectedColumnIndex();
                        if (idx < 0) {
                            logger.error((Object)"CantHappen: idx < 0");
                            JOptionPane.showMessageDialog(this.pp, "Please select the column you would like to edit.");
                            break block20;
                        }
                        this.makeDialog(tp.getModel(), idx);
                    }
                    catch (ArchitectException e) {
                        JOptionPane.showMessageDialog(this.pp, "Error finding the selected column");
                        logger.error((Object)"Error finding the selected column", (Throwable)e);
                        this.cleanup();
                    }
                } else {
                    JOptionPane.showMessageDialog(this.pp, "Please select the column you would like to edit.");
                    this.cleanup();
                }
            } else if (evt.getActionCommand().equals("DBTree")) {
                TreePath[] selections = this.dbt.getSelectionPaths();
                logger.debug((Object)("selections length is: " + selections.length));
                if (selections.length != 1) {
                    JOptionPane.showMessageDialog(this.dbt, "Please select the column you would like to edit.");
                } else {
                    TreePath tp = selections[0];
                    SQLObject so = (SQLObject)tp.getLastPathComponent();
                    if (so instanceof SQLColumn) {
                        SQLColumn sc = (SQLColumn)so;
                        SQLTable st = sc.getParentTable();
                        try {
                            int idx = st.getColumnIndex(sc);
                            if (idx < 0) {
                                JOptionPane.showMessageDialog(this.dbt, "Error finding the selected column");
                                break block20;
                            }
                            this.makeDialog(st, idx);
                        }
                        catch (ArchitectException ex) {
                            JOptionPane.showMessageDialog(this.dbt, "Error finding the selected column");
                            logger.error((Object)"Error finding the selected column", (Throwable)ex);
                            this.cleanup();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.dbt, "Please select the column you would like to edit.");
                    }
                }
            }
        }
    }

    private void makeDialog(SQLTable st, int colIdx) throws ArchitectException {
        if (this.editDialog != null) {
            this.columnEditPanel.editColumn(st.getColumn(colIdx));
            this.editDialog.setTitle("Column Properties of " + st.getName());
            this.editDialog.setVisible(true);
        } else {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout(12, 12));
            panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.columnEditPanel = new ColumnEditPanel(st.getColumn(colIdx));
            panel.add((Component)this.columnEditPanel, "Center");
            this.editDialog = ArchitectPanelBuilder.createArchitectPanelDialog(this.columnEditPanel, ArchitectFrame.getMainInstance(), "Column Properties of " + st.getName(), "OK", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    EditColumnAction.this.columnEditPanel.applyChanges();
                    EditColumnAction.this.putValue("ShortDescription", "Editting " + EditColumnAction.this.columnEditPanel.getColName().getText());
                }
            }, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    EditColumnAction.this.columnEditPanel.discardChanges();
                }
            });
            panel.setOpaque(true);
            this.editDialog.pack();
            this.editDialog.setLocationRelativeTo(ArchitectFrame.getMainInstance());
            this.editDialog.setVisible(true);
        }
    }

    protected void cleanup() {
        if (this.editDialog != null) {
            this.editDialog.setVisible(false);
            this.editDialog.dispose();
            this.editDialog = null;
        }
    }

    public void setPlayPen(PlayPen newPP) {
        if (this.pp != null) {
            this.pp.removeSelectionListener(this);
        }
        this.pp = newPP;
        this.pp.addSelectionListener(this);
        this.setupAction(this.pp.getSelectedItems());
    }

    public void setDBTree(DBTree newDBT) {
        this.dbt = newDBT;
    }

    private void setupAction(List selectedItems) {
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            logger.debug((Object)"Disabling EditColumnAction");
            this.putValue("ShortDescription", "Edit Selected Column");
        } else {
            Selectable item = (Selectable)selectedItems.get(0);
            String name = "Selected";
            logger.debug((Object)"Selected Table");
            if (item instanceof TablePane) {
                TablePane tp = (TablePane)item;
                if (tp.getSelectedColumnIndex() > -1) {
                    try {
                        logger.debug((Object)"Enabling EditColumnAction");
                        this.setEnabled(true);
                        name = tp.getModel().getColumn(tp.getSelectedColumnIndex()).getName();
                    }
                    catch (ArchitectException ex) {
                        logger.error((Object)"Couldn't get selected column name", (Throwable)ex);
                    }
                } else {
                    name = tp.getModel().toString();
                    this.setEnabled(false);
                    logger.debug((Object)"Disabling EditColumnAction");
                }
            }
            this.putValue("ShortDescription", "Editting " + name);
        }
    }

    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }

    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }
}

