/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLSchema
extends SQLObject {
    private static final Logger logger = Logger.getLogger(SQLSchema.class);
    protected SQLObject parent;
    protected String nativeTerm;

    public SQLSchema(boolean populated) {
        this(null, null, populated);
    }

    public SQLSchema(SQLObject parent, String name, boolean populated) {
        if (parent != null && !(parent instanceof SQLCatalog) && !(parent instanceof SQLDatabase)) {
            throw new IllegalArgumentException("Parent to SQLSchema must be SQLCatalog or SQLDatabase");
        }
        this.parent = parent;
        this.setName(name);
        this.children = new LinkedList();
        this.nativeTerm = "schema";
        this.populated = populated;
    }

    public SQLTable getTableByName(String tableName) throws ArchitectException {
        this.populate();
        for (SQLTable child : this.children) {
            logger.debug((Object)("getTableByName: is child '" + child.getName() + "' equal to '" + tableName + "'?"));
            if (!child.getName().equalsIgnoreCase(tableName)) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    public boolean isParentTypeDatabase() {
        return this.parent instanceof SQLDatabase;
    }

    @Override
    public SQLObject getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(SQLObject newParent) {
        this.parent = newParent;
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void populate() throws ArchitectException {
        block28: {
            ResultSet rs;
            Connection con;
            int oldSize;
            block26: {
                SQLObject tmp;
                if (this.populated) {
                    return;
                }
                logger.debug((Object)"SQLSchema: populate starting");
                oldSize = this.children.size();
                for (tmp = this.parent; tmp != null && !(tmp instanceof SQLDatabase); tmp = tmp.getParent()) {
                }
                if (tmp == null) {
                    throw new IllegalStateException("Schema does not have a SQLDatabase ancestor. Can't populate.");
                }
                SQLDatabase parentDatabase = (SQLDatabase)tmp;
                con = null;
                rs = null;
                SQLDatabase sQLDatabase = parentDatabase;
                synchronized (sQLDatabase) {
                    con = parentDatabase.getConnection();
                    DatabaseMetaData dbmd = con.getMetaData();
                    if (this.parent instanceof SQLDatabase) {
                        SQLTable.addTablesToTableContainer(this, dbmd, null, this.getName());
                    } else if (this.parent instanceof SQLCatalog) {
                        SQLTable.addTablesToTableContainer(this, dbmd, this.parent.getName(), this.getName());
                    }
                }
                Object var10_10 = null;
                this.populated = true;
                int newSize = this.children.size();
                if (newSize <= oldSize) break block26;
                int[] changedIndices = new int[newSize - oldSize];
                int n = newSize - oldSize;
                for (int i = 0; i < n; ++i) {
                    changedIndices[i] = oldSize + i;
                }
                this.fireDbChildrenInserted(changedIndices, this.children.subList(oldSize, newSize));
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                logger.error((Object)"Could not close result set", (Throwable)e2);
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block28;
            }
            catch (SQLException e2) {
                logger.error((Object)"Could not close connection", (Throwable)e2);
            }
            break block28;
            {
                catch (SQLException e) {
                    throw new ArchitectException("schema.populate.fail", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.populated = true;
                int newSize = this.children.size();
                if (newSize > oldSize) {
                    int[] changedIndices = new int[newSize - oldSize];
                    int n = newSize - oldSize;
                    for (int i = 0; i < n; ++i) {
                        changedIndices[i] = oldSize + i;
                    }
                    this.fireDbChildrenInserted(changedIndices, this.children.subList(oldSize, newSize));
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"Could not close result set", (Throwable)e2);
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"Could not close connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
        logger.debug((Object)"SQLSchema: populate finished");
    }

    public String getNativeTerm() {
        return this.nativeTerm;
    }

    public void setNativeTerm(String argNativeTerm) {
        if (argNativeTerm != null) {
            argNativeTerm = argNativeTerm.toLowerCase();
        }
        this.nativeTerm = argNativeTerm;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return SQLTable.class;
    }
}

