# -*- coding: utf-8 -*-
# 
# The LIRC Plugin for elisa
# 
# Copyright (C) 2008 by Benjamin Kampmann <big.master.ben@web.de>
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 
# Author: Benjamin Kampmann <big.master.ben@web.de>

if __name__ == '__main__':

# import and install the glib2reactor is the first thing today in case we
# execute directly
    from twisted.internet import glib2reactor
    glib2reactor.install()

    from twisted.internet import reactor

    import sys, os

    from elisa.plugins.lirc.lirc_input import LircInput

    class InputManagerFake(object):

        def process_event(self, event):
            print "Received", event


    res = None
    def setup_done(resource):
        global res
        res = resource
        res.input_manager = InputManagerFake()
        print "****************************"
        print "Start to press some buttons!"

    def setup(config):
        dfr = LircInput.create(config)
        dfr.addCallback(setup_done)


    args = sys.argv

    file = '%s/.elisa/lirc_input_map' % os.path.expanduser('~')
    device = '/dev/lircd'

    if len(args) < 2:
        print "no lirc input map file given. using %s" % file
    else:
        file = args[1]
        print "testing lirc input map %s" % file
        if len(args) == 3:
            device = args[2]
            print "and using device %s" % device

    config = {'input_map' : file,
              'device' : device }
    reactor.callWhenRunning(setup, config)
    reactor.run()
