# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.core import common

def get_flickr_provider():
    """ A little helper to find the Flickr resource_provider instance
    in the resource_manager.

    @rtype: L{elisa.core.components.resource_provider.ResourceProvider}
    """
    provider_path = 'elisa.plugins.flickr.resource_provider:FlickrResourceProvider'
    manager = common.application.resource_manager
    provider = manager.get_resource_provider_by_path(provider_path)
    return provider
