/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef VMIMETOMAPI
#define VMIMETOMAPI

#include <vmime/vmime.hpp>
#include <mapix.h>
#include "mapidefs.h"
#include "ECLogger.h"
#include "options.h"

// We currently always write PR_BODY and PR_SUBJECT, etc as windows-1252
// charset. This is good enough to support western-european e-mail
// We don't set PR_INTERNET_CPID, and windows therefore assumes windows-1252
#define MAPI_CHARSET vmime::charset(vmime::charsets::WINDOWS_1252)

enum BODYLEVEL { BODY_NONE, BODY_PLAIN, BODY_HTML };
enum ATTACHLEVEL { ATTACH_NONE, ATTACH_INLINE, ATTACH_NORMAL };

class VMIMEToMAPI
{
public:
	VMIMEToMAPI();
	VMIMEToMAPI(LPADRBOOK lpAdrBook, ECLogger *newlogger, delivery_options dopt);
	virtual	~VMIMEToMAPI();

	HRESULT convertVMIMEToMAPI(const string &input, IMessage *lpMessage);

private:
	ECLogger *lpLogger;
	bool delete_logger;
	delivery_options m_dopt;
	LPADRBOOK m_lpAdrBook;
	IABContainer *m_lpDefaultDir;
	BODYLEVEL bodyLevel;
	ATTACHLEVEL attachLevel;
	bool attach_signature;
	bool m_bIsMsgInMsg;

	HRESULT fillMAPIMail(vmime::message* VMMessage, IMessage *lpMessage);
	HRESULT disectBody(vmime::header* VMHeader, vmime::body* VMBody, IMessage* lpMessage, bool onlyBody = false, bool filterDouble = false, bool bAppendBody = false);

	HRESULT handleHeaders(vmime::header* VMHeader, IMessage* lpMessage);
	HRESULT handleRecipients(vmime::header* VMHeader, IMessage* lpMessage);
	HRESULT modifyRecipientList(LPADRLIST lpRecipients, const vmime::addressList* lpVMAddressList, ULONG ulRecipType);
	HRESULT modifyFromAddressBook(LPSPropValue *lppPropVals, ULONG *lpulValues, const char *email, const char *fullname, ULONG ulRecipType, LPSPropTagArray lpPropsList);

	HRESULT handleTextpart(vmime::header* VMHeader, vmime::body* VMBody, IMessage* lpMessage, bool bAppendBody);
	HRESULT handleHTMLTextpart(vmime::header* VMHeader, vmime::body* VMBody, IMessage* lpMessage, bool bAppendBody);
	HRESULT handleAttachment(vmime::header* VMHeader, vmime::body* VMBody, IMessage* lpMessage);
	HRESULT handleMessageToMeProps(IMessage *lpMessage, LPADRLIST lpRecipients);
	
	HRESULT postWriteFixups(IMessage *lpMessage);
};

#endif
