/* gdu.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gdu", lower_case_cprefix = "gdu_")]
namespace Gdu {
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Adapter : GLib.Object {
		public unowned string get_driver ();
		public unowned string get_fabric ();
		public unowned string get_model ();
		public unowned string get_native_path ();
		public uint get_num_ports ();
		public unowned string get_object_path ();
		public unowned Gdu.Pool get_pool ();
		public unowned string get_vendor ();
		public virtual signal void changed ();
		public virtual signal void removed ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Device : GLib.Object {
		public void* drive_ata_smart_get_blob (size_t out_size);
		public bool drive_ata_smart_get_is_available ();
		public unowned string drive_ata_smart_get_status ();
		public uint64 drive_ata_smart_get_time_collected ();
		public void drive_ata_smart_refresh_data (Gdu.DeviceDriveAtaSmartRefreshDataCompletedFunc callback);
		public unowned string drive_get_adapter ();
		public bool drive_get_can_detach ();
		public bool drive_get_can_spindown ();
		public unowned string drive_get_connection_interface ();
		public uint64 drive_get_connection_speed ();
		public bool drive_get_is_media_ejectable ();
		public bool drive_get_is_rotational ();
		public unowned string drive_get_media ();
		public unowned string drive_get_media_compatibility ();
		public unowned string drive_get_model ();
		public unowned string drive_get_ports ();
		public bool drive_get_requires_eject ();
		public unowned string drive_get_revision ();
		public uint drive_get_rotation_rate ();
		public unowned string drive_get_serial ();
		public unowned string drive_get_similar_devices ();
		public unowned string drive_get_vendor ();
		public unowned string drive_get_write_cache ();
		public unowned string drive_get_wwn ();
		public void filesystem_list_open_files (Gdu.DeviceFilesystemListOpenFilesCompletedFunc callback);
		public unowned GLib.List filesystem_list_open_files_sync () throws GLib.Error;
		public unowned Gdu.Device find_parent ();
		public uint64 get_block_size ();
		public uint64 get_detection_time ();
		public ulong get_dev ();
		public unowned string get_device_file ();
		public unowned string get_device_file_presentation ();
		public uint64 get_media_detection_time ();
		public unowned string get_mount_path ();
		public unowned string get_mount_paths ();
		public ulong get_mounted_by_uid ();
		public unowned string get_object_path ();
		public unowned Gdu.Pool get_pool ();
		public bool get_presentation_hide ();
		public unowned string get_presentation_icon_name ();
		public unowned string get_presentation_name ();
		public bool get_presentation_nopolicy ();
		public uint64 get_size ();
		public unowned string id_get_label ();
		public unowned string id_get_type ();
		public unowned string id_get_usage ();
		public unowned string id_get_uuid ();
		public unowned string id_get_version ();
		public bool is_drive ();
		public bool is_linux_dmmp ();
		public bool is_linux_dmmp_component ();
		public bool is_linux_loop ();
		public bool is_linux_lvm2_lv ();
		public bool is_linux_lvm2_pv ();
		public bool is_linux_md ();
		public bool is_linux_md_component ();
		public bool is_luks ();
		public bool is_luks_cleartext ();
		public bool is_media_available ();
		public bool is_media_change_detected ();
		public bool is_media_change_detection_inhibitable ();
		public bool is_media_change_detection_inhibited ();
		public bool is_media_change_detection_polling ();
		public bool is_mounted ();
		public bool is_optical_disc ();
		public bool is_partition ();
		public bool is_partition_table ();
		public bool is_read_only ();
		public bool is_removable ();
		public bool is_system_internal ();
		public unowned string job_get_id ();
		public ulong job_get_initiated_by_uid ();
		public double job_get_percentage ();
		public bool job_in_progress ();
		public bool job_is_cancellable ();
		public unowned string linux_dmmp_component_get_holder ();
		public unowned string linux_dmmp_get_name ();
		public unowned string linux_dmmp_get_parameters ();
		public unowned string linux_dmmp_get_slaves ();
		public unowned string linux_loop_get_filename ();
		public unowned string linux_lvm2_lv_get_group_name ();
		public unowned string linux_lvm2_lv_get_group_uuid ();
		public unowned string linux_lvm2_lv_get_name ();
		public unowned string linux_lvm2_lv_get_uuid ();
		public uint64 linux_lvm2_pv_get_group_extent_size ();
		public unowned string linux_lvm2_pv_get_group_logical_volumes ();
		public unowned string linux_lvm2_pv_get_group_name ();
		public unowned string linux_lvm2_pv_get_group_physical_volumes ();
		public uint64 linux_lvm2_pv_get_group_sequence_number ();
		public uint64 linux_lvm2_pv_get_group_size ();
		public uint64 linux_lvm2_pv_get_group_unallocated_size ();
		public unowned string linux_lvm2_pv_get_group_uuid ();
		public uint linux_lvm2_pv_get_num_metadata_areas ();
		public unowned string linux_lvm2_pv_get_uuid ();
		public unowned string linux_md_component_get_holder ();
		public unowned string linux_md_component_get_home_host ();
		public unowned string linux_md_component_get_level ();
		public unowned string linux_md_component_get_name ();
		public int linux_md_component_get_num_raid_devices ();
		public int linux_md_component_get_position ();
		public unowned string linux_md_component_get_state ();
		public unowned string linux_md_component_get_uuid ();
		public unowned string linux_md_component_get_version ();
		public unowned string linux_md_get_home_host ();
		public unowned string linux_md_get_level ();
		public unowned string linux_md_get_name ();
		public int linux_md_get_num_raid_devices ();
		public unowned string linux_md_get_slaves ();
		public unowned string linux_md_get_state ();
		public unowned string linux_md_get_sync_action ();
		public double linux_md_get_sync_percentage ();
		public uint64 linux_md_get_sync_speed ();
		public unowned string linux_md_get_uuid ();
		public unowned string linux_md_get_version ();
		public bool linux_md_is_degraded ();
		public unowned string luks_cleartext_get_slave ();
		public ulong luks_cleartext_unlocked_by_uid ();
		public unowned string luks_get_holder ();
		public void op_cancel_job (Gdu.DeviceCancelJobCompletedFunc callback);
		public void op_drive_ata_smart_initiate_selftest (string test, Gdu.DeviceDriveAtaSmartInitiateSelftestCompletedFunc callback);
		public void op_drive_benchmark (bool do_write_benchmark, string options, Gdu.DeviceDriveBenchmarkCompletedFunc callback);
		public void op_drive_detach (Gdu.DeviceDriveDetachCompletedFunc callback);
		public void op_drive_eject (Gdu.DeviceDriveEjectCompletedFunc callback);
		public void op_drive_poll_media (Gdu.DeviceDrivePollMediaCompletedFunc callback);
		public void op_filesystem_check (Gdu.DeviceFilesystemCheckCompletedFunc callback);
		public void op_filesystem_create (string fstype, string fslabel, string encrypt_passphrase, bool fs_take_ownership, Gdu.DeviceFilesystemCreateCompletedFunc callback);
		public void op_filesystem_mount (string options, Gdu.DeviceFilesystemMountCompletedFunc callback);
		public void op_filesystem_set_label (string new_label, Gdu.DeviceFilesystemSetLabelCompletedFunc callback);
		public void op_filesystem_unmount (Gdu.DeviceFilesystemUnmountCompletedFunc callback);
		public void op_linux_lvm2_lv_stop (Gdu.DeviceLinuxLvm2LVStopCompletedFunc callback);
		public void op_linux_md_add_spare (string component_objpath, Gdu.DeviceLinuxMdAddSpareCompletedFunc callback);
		public void op_linux_md_check (string options, Gdu.DeviceLinuxMdCheckCompletedFunc callback);
		public void op_linux_md_expand (GLib.PtrArray component_objpaths, Gdu.DeviceLinuxMdExpandCompletedFunc callback);
		public void op_linux_md_remove_component (string component_objpath, Gdu.DeviceLinuxMdRemoveComponentCompletedFunc callback);
		public void op_linux_md_stop (Gdu.DeviceLinuxMdStopCompletedFunc callback);
		public void op_luks_change_passphrase (string old_secret, string new_secret, Gdu.DeviceLuksChangePassphraseCompletedFunc callback);
		public void op_luks_lock (Gdu.DeviceLuksLockCompletedFunc callback);
		public void op_luks_unlock (string secret, Gdu.DeviceLuksUnlockCompletedFunc callback);
		public void op_partition_create (uint64 offset, uint64 size, string type, string label, out unowned string flags, string fstype, string fslabel, string encrypt_passphrase, bool fs_take_ownership, Gdu.DevicePartitionCreateCompletedFunc callback);
		public void op_partition_delete (Gdu.DevicePartitionDeleteCompletedFunc callback);
		public void op_partition_modify (string type, string label, out unowned string flags, Gdu.DevicePartitionModifyCompletedFunc callback);
		public void op_partition_table_create (string scheme, Gdu.DevicePartitionTableCreateCompletedFunc callback);
		public bool optical_disc_get_is_appendable ();
		public bool optical_disc_get_is_blank ();
		public bool optical_disc_get_is_closed ();
		public uint optical_disc_get_num_audio_tracks ();
		public uint optical_disc_get_num_sessions ();
		public uint optical_disc_get_num_tracks ();
		public uint64 partition_get_alignment_offset ();
		public unowned string partition_get_flags ();
		public unowned string partition_get_label ();
		public int partition_get_number ();
		public uint64 partition_get_offset ();
		public unowned string partition_get_scheme ();
		public uint64 partition_get_size ();
		public unowned string partition_get_slave ();
		public unowned string partition_get_type ();
		public unowned string partition_get_uuid ();
		public int partition_table_get_count ();
		public unowned string partition_table_get_scheme ();
		public bool should_ignore ();
		public virtual signal void changed ();
		public virtual signal void job_changed ();
		public virtual signal void removed ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Drive : GLib.Object, Gdu.Presentable {
		public virtual void activate (Gdu.DriveActivateFunc callback);
		public virtual bool can_activate (bool out_degraded);
		public virtual bool can_create_volume (bool out_is_uninitialized, uint64 out_largest_contiguous_free_segment, uint64 out_total_free, out unowned Gdu.Presentable out_presentable);
		public virtual bool can_deactivate ();
		public bool count_mbr_partitions (uint out_num_primary_partitions, bool out_has_extended_partition);
		public virtual void create_volume (uint64 size, string name, Gdu.CreateVolumeFlags flags, GLib.AsyncReadyCallback callback);
		public virtual unowned Gdu.Volume create_volume_finish (GLib.AsyncResult res) throws GLib.Error;
		public virtual void deactivate (Gdu.DriveDeactivateFunc callback);
		public unowned GLib.List get_volumes ();
		public virtual bool is_activatable ();
		public virtual bool is_active ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Expander : GLib.Object {
		public unowned string get_adapter ();
		public unowned string get_model ();
		public unowned string get_native_path ();
		public uint get_num_ports ();
		public unowned string get_object_path ();
		public unowned Gdu.Pool get_pool ();
		public unowned string get_revision ();
		public unowned string get_upstream_ports ();
		public unowned string get_vendor ();
		public virtual signal void changed ();
		public virtual signal void removed ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Hub : GLib.Object, Gdu.Presentable {
		public unowned Gdu.Adapter get_adapter ();
		public unowned Gdu.Expander get_expander ();
		public Gdu.HubUsage get_usage ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class KnownFilesystem : GLib.Object {
		public bool get_can_create ();
		public bool get_can_mount ();
		public unowned string get_id ();
		public uint get_max_label_len ();
		public unowned string get_name ();
		public bool get_supports_fsck ();
		public bool get_supports_label_rename ();
		public bool get_supports_online_fsck ();
		public bool get_supports_online_label_rename ();
		public bool get_supports_online_resize_enlarge ();
		public bool get_supports_online_resize_shrink ();
		public bool get_supports_resize_enlarge ();
		public bool get_supports_resize_shrink ();
		public bool get_supports_unix_owners ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class LinuxLvm2Volume : Gdu.Volume, Gdu.Presentable {
		public unowned string get_group_uuid ();
		public unowned string get_uuid ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class LinuxLvm2VolumeGroup : Gdu.Drive, Gdu.Presentable {
		public unowned string get_compute_new_lv_name ();
		public bool get_lv_info (string lv_uuid, uint out_position, string out_name, uint64 out_size);
		public uint get_num_lvs ();
		public unowned Gdu.Device get_pv_device ();
		public bool get_pv_info (string pv_uuid, uint out_position, uint64 out_size, uint64 out_allocated_size);
		public Gdu.LinuxLvm2VolumeGroupState get_state ();
		public unowned string get_uuid ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class LinuxLvm2VolumeHole : Gdu.VolumeHole, Gdu.Presentable {
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class LinuxMdDrive : Gdu.Drive, Gdu.Presentable {
		public Gdu.LinuxMdDriveSlaveFlags get_slave_flags (Gdu.Device slave);
		public unowned string get_slave_state_markup (Gdu.Device slave);
		public unowned GLib.List get_slaves ();
		public unowned string get_uuid ();
		public bool has_slave (Gdu.Device device);
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Machine : GLib.Object, Gdu.Presentable {
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Pool : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pool ();
		[CCode (has_construct_function = false)]
		public Pool.for_address (string ssh_user_name, string ssh_address) throws GLib.Error;
		public unowned Gdu.Adapter get_adapter_by_object_path (string object_path);
		public unowned GLib.List get_adapters ();
		public unowned Gdu.Device get_by_device_file (string device_file);
		public unowned Gdu.Device get_by_object_path (string object_path);
		public unowned string get_daemon_version ();
		public unowned GLib.List get_devices ();
		public unowned Gdu.Presentable get_drive_by_device (Gdu.Device device);
		public unowned GLib.List get_enclosed_presentables (Gdu.Presentable presentable);
		public unowned Gdu.Expander get_expander_by_object_path (string object_path);
		public unowned GLib.List get_expanders ();
		public unowned Gdu.Presentable get_hub_by_object_path (string object_path);
		public unowned Gdu.KnownFilesystem get_known_filesystem_by_id (string id);
		public unowned GLib.List get_known_filesystems ();
		public unowned Gdu.LinuxMdDrive get_linux_md_drive_by_uuid (string uuid);
		public unowned Gdu.Port get_port_by_object_path (string object_path);
		public unowned GLib.List get_ports ();
		public unowned Gdu.Presentable get_presentable_by_id (string id);
		public unowned GLib.List get_presentables ();
		public unowned string get_ssh_address ();
		public unowned string get_ssh_user_name ();
		public unowned Gdu.Presentable get_volume_by_device (Gdu.Device device);
		public bool has_presentable (Gdu.Presentable presentable);
		public bool is_daemon_inhibited ();
		public void op_linux_lvm2_lv_create (string group_uuid, string name, uint64 size, uint num_stripes, uint64 stripe_size, uint num_mirrors, string fstype, string fslabel, string encrypt_passphrase, bool fs_take_ownership, Gdu.PoolLinuxLvm2LVCreateCompletedFunc callback);
		public void op_linux_lvm2_lv_remove (string group_uuid, string uuid, Gdu.PoolLinuxLvm2LVRemoveCompletedFunc callback);
		public void op_linux_lvm2_lv_set_name (string group_uuid, string uuid, string new_name, Gdu.PoolLinuxLvm2LVSetNameCompletedFunc callback);
		public void op_linux_lvm2_lv_start (string group_uuid, string uuid, Gdu.PoolLinuxLvm2VGStartCompletedFunc callback);
		public void op_linux_lvm2_vg_add_pv (string uuid, string physical_volume_object_path, Gdu.PoolLinuxLvm2VGAddPVCompletedFunc callback);
		public void op_linux_lvm2_vg_remove_pv (string vg_uuid, string pv_uuid, Gdu.PoolLinuxLvm2VGRemovePVCompletedFunc callback);
		public void op_linux_lvm2_vg_set_name (string uuid, string new_name, Gdu.PoolLinuxLvm2VGSetNameCompletedFunc callback);
		public void op_linux_lvm2_vg_start (string uuid, Gdu.PoolLinuxLvm2VGStartCompletedFunc callback);
		public void op_linux_lvm2_vg_stop (string uuid, Gdu.PoolLinuxLvm2VGStopCompletedFunc callback);
		public void op_linux_md_create (GLib.PtrArray component_objpaths, string level, uint64 stripe_size, string name, Gdu.PoolLinuxMdCreateCompletedFunc callback);
		public void op_linux_md_start (GLib.PtrArray component_objpaths, Gdu.PoolLinuxMdStartCompletedFunc callback);
		public bool supports_luks_devices ();
		public virtual signal void adapter_added (Gdu.Adapter adapter);
		public virtual signal void adapter_changed (Gdu.Adapter adapter);
		public virtual signal void adapter_removed (Gdu.Adapter adapter);
		public virtual signal void device_added (Gdu.Device device);
		public virtual signal void device_changed (Gdu.Device device);
		public virtual signal void device_job_changed (Gdu.Device device);
		public virtual signal void device_removed (Gdu.Device device);
		public virtual signal void disconnected ();
		public virtual signal void expander_added (Gdu.Expander expander);
		public virtual signal void expander_changed (Gdu.Expander expander);
		public virtual signal void expander_removed (Gdu.Expander expander);
		public virtual signal void port_added (Gdu.Port port);
		public virtual signal void port_changed (Gdu.Port port);
		public virtual signal void port_removed (Gdu.Port port);
		public virtual signal void presentable_added (Gdu.Presentable presentable);
		public virtual signal void presentable_changed (Gdu.Presentable presentable);
		public virtual signal void presentable_job_changed (Gdu.Presentable presentable);
		public virtual signal void presentable_removed (Gdu.Presentable presentable);
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Port : GLib.Object {
		public unowned string get_adapter ();
		public unowned string get_connector_type ();
		public unowned string get_native_path ();
		public int get_number ();
		public unowned string get_object_path ();
		public unowned string get_parent ();
		public unowned Gdu.Pool get_pool ();
		public virtual signal void changed ();
		public virtual signal void removed ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Process : GLib.Object {
		public unowned GLib.AppInfo get_app_info ();
		public unowned string get_command_line ();
		public int get_id ();
		public ulong get_owner ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class Volume : GLib.Object, Gdu.Presentable {
		public unowned Gdu.Drive get_drive ();
		public virtual Gdu.VolumeFlags get_flags ();
		public virtual bool is_allocated ();
		public virtual bool is_recognized ();
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public class VolumeHole : GLib.Object, Gdu.Presentable {
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public interface Presentable : GLib.Object {
		public int compare (Gdu.Presentable b);
		public bool encloses (Gdu.Presentable b);
		public bool equals (Gdu.Presentable b);
		public abstract unowned string get_description ();
		public abstract unowned Gdu.Device get_device ();
		public unowned GLib.List get_enclosed ();
		public abstract unowned Gdu.Presentable get_enclosing_presentable ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_id ();
		public abstract unowned string get_name ();
		public abstract uint64 get_offset ();
		public abstract unowned Gdu.Pool get_pool ();
		public abstract uint64 get_size ();
		public unowned Gdu.Presentable get_toplevel ();
		public abstract unowned string get_vpd_name ();
		public uint hash ();
		public abstract bool is_allocated ();
		public abstract bool is_recognized ();
		public signal void changed ();
		public signal void job_changed ();
		public signal void removed ();
	}
	[CCode (cprefix = "GDU_CREATE_VOLUME_FLAGS_", has_type_id = false, cheader_filename = "gdu/gdu.h")]
	public enum CreateVolumeFlags {
		NONE,
		LINUX_MD,
		LINUX_LVM2
	}
	[CCode (cprefix = "GDU_ERROR_", has_type_id = false, cheader_filename = "gdu/gdu.h")]
	public enum Error {
		FAILED,
		BUSY,
		CANCELLED,
		INHIBITED,
		INVALID_OPTION,
		NOT_SUPPORTED,
		ATA_SMART_WOULD_WAKEUP,
		PERMISSION_DENIED,
		FILESYSTEM_DRIVER_MISSING,
		FILESYSTEM_TOOLS_MISSING
	}
	[CCode (cprefix = "GDU_HUB_USAGE_", has_type_id = false, cheader_filename = "gdu/gdu.h")]
	public enum HubUsage {
		ADAPTER,
		EXPANDER,
		MULTI_DISK_DEVICES,
		MULTI_PATH_DEVICES
	}
	[CCode (cprefix = "GDU_LINUX_LVM2_VOLUME_GROUP_STATE_", has_type_id = false, cheader_filename = "gdu/gdu.h")]
	public enum LinuxLvm2VolumeGroupState {
		NOT_RUNNING,
		PARTIALLY_RUNNING,
		RUNNING
	}
	[CCode (cprefix = "GDU_LINUX_MD_DRIVE_SLAVE_FLAGS_", has_type_id = false, cheader_filename = "gdu/gdu.h")]
	public enum LinuxMdDriveSlaveFlags {
		NONE,
		NOT_ATTACHED,
		FAULTY,
		IN_SYNC,
		WRITEMOSTLY,
		BLOCKED,
		SPARE
	}
	[CCode (cprefix = "GDU_VOLUME_FLAGS_", has_type_id = false, cheader_filename = "gdu/gdu.h")]
	public enum VolumeFlags {
		NONE,
		PARTITION,
		PARTITION_MBR_LOGICAL,
		PARTITION_MBR_EXTENDED
	}
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceCancelJobCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveAtaSmartInitiateSelftestCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveAtaSmartRefreshDataCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveBenchmarkCompletedFunc (Gdu.Device device, GLib.PtrArray read_transfer_rate_results, GLib.PtrArray write_transfer_rate_results, GLib.PtrArray access_time_results, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveDetachCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDriveEjectCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceDrivePollMediaCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemCheckCompletedFunc (Gdu.Device device, bool is_clean, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemCreateCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemListOpenFilesCompletedFunc (Gdu.Device device, GLib.List processes, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemMountCompletedFunc (Gdu.Device device, string mount_point, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemSetLabelCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceFilesystemUnmountCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxLvm2LVStopCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdAddSpareCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdCheckCompletedFunc (Gdu.Device device, uint num_errors, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdExpandCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdRemoveComponentCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLinuxMdStopCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLuksChangePassphraseCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLuksLockCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DeviceLuksUnlockCompletedFunc (Gdu.Device device, string object_path_of_cleartext_device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionCreateCompletedFunc (Gdu.Device device, string created_device_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionDeleteCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionModifyCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DevicePartitionTableCreateCompletedFunc (Gdu.Device device, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DriveActivateFunc (Gdu.Drive drive, string assembled_drive_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void DriveDeactivateFunc (Gdu.Drive drive, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2LVCreateCompletedFunc (Gdu.Pool pool, string create_logical_volume_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2LVRemoveCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2LVSetNameCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2LVStartCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2VGAddPVCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2VGRemovePVCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2VGSetNameCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2VGStartCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxLvm2VGStopCompletedFunc (Gdu.Pool pool, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxMdCreateCompletedFunc (Gdu.Pool pool, string array_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void PoolLinuxMdStartCompletedFunc (Gdu.Pool pool, string assembled_array_object_path, GLib.Error error);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public delegate void UtilPartTypeForeachFunc (string scheme, string type, string name);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string get_job_description (string job_id);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string linux_md_get_raid_level_description (string linux_md_raid_level);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string linux_md_get_raid_level_for_display (string linux_md_raid_level, bool long_string);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_ata_smart_status_to_desc (string status, bool out_highlight, string out_action_text, out unowned GLib.Icon out_icon);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static bool util_delete_secret (Gdu.Device device);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_fstype_get_description (string fstype);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_connection_for_display (string connection_interface, uint64 connection_speed);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_default_part_type_for_scheme_and_fstype (string scheme, string fstype, uint64 size);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_desc_for_part_type (string part_scheme, string part_type);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned GLib.Icon util_get_emblemed_icon (string name, string emblem_name);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_fstype_for_display (string fstype, string fsversion, bool long_string);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_secret (Gdu.Device device);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_size_for_display (uint64 size, bool use_pow2, bool long_string);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_get_speed_for_display (uint64 size);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static bool util_have_secret (Gdu.Device device);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static unowned string util_part_table_type_get_description (string part_type);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static void util_part_type_foreach (Gdu.UtilPartTypeForeachFunc callback);
	[CCode (cheader_filename = "gdu/gdu.h")]
	public static bool util_save_secret (Gdu.Device device, string secret, bool save_in_keyring_session);
}
