#! /usr/bin/perl

# init_comment.pl - This script initializes subscriber comments in DB
# RCS Identication ; $Revision: 5958 $ ; $Date: 2009-07-10 16:44:46 +0200 (ven 10 jui 2009) $ 
#
# Sympa - SYsteme de Multi-Postage Automatique
# Copyright (c) 1997, 1998, 1999, 2000, 2001 Comite Reseau des Universites
# Copyright (c) 1997,1998, 1999 Institut Pasteur & Christophe Wolfhugel
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

use lib '/usr/local/libdata/perl5/site_perl/Sympa';
use wwslib;
use Sympa::Constants;

use List;
use Log;

## Load sympa config
&Conf::load(Sympa::Constants::CONFIG) || die 'config_error';

chdir $Conf::Conf{'home'};

&List::db_connect() || die "Can't connect to database";

my $dbh = &List::db_get_handler();

my $sth =  $dbh->prepare("SELECT user_subscriber, comment_subscriber FROM subscriber_table") || die "Can't prepare SQL statement";

$sth->execute || die "Unable to execute SQL statement";

my $user;

while ($user = $sth->fetchrow_hashref('NAME_lc')) {
    printf "\nUser: %s", $user->{'user_subscriber'};

    unless ($user->{'comment_subscriber'}) {
	my $statement = sprintf "SELECT gecos_user FROM user_table WHERE email_user=%s", $dbh->quote($user->{'user_subscriber'});
	my $sth2 =  $dbh->prepare($statement) || die "Can't prepare SQL statement";
	
	$sth2->execute || die "Unable to execute SQL statement";

	my $gecos = $sth2->fetchrow;
	$sth2->finish();
	
	if ($gecos) {
	    printf " =>%s", $gecos;
	    my $statement = sprintf "UPDATE subscriber_table SET comment_subscriber=%s WHERE (user_subscriber=%s)", $dbh->quote($gecos), $dbh->quote($user->{'user_subscriber'});
	    my $sth2 =  $dbh->prepare($statement) || die "Can't prepare SQL statement";
	    $sth2->execute || die "Unable to execute SQL statement";
	    $sth2->finish();
	}
	
    }
}

$sth->finish();

&List::db_disconnect();
