# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from twisted.trial.unittest import SkipTest, TestCase

# an import of storm_wrapper needs to be done before you can use anything
# related to storm
import elisa.extern.storm_wrapper
from elisa.extern.twisted_storm.store import StoreThread
from elisa.core.utils.defer import CancelledError

class StormWrapperTest(TestCase):
    def test_import(self):
        """tests only if the import of elisa.extern.storm_wrapper works proper"""
        try:
            import storm
        except ImportError:
            raise SkipTest("Storm missing. Can't run storm")

        from elisa.extern.storm_wrapper import store, wrapper

class StoreThreadTest(TestCase):
    """
    Tests for L{StoreThread}.
    """

    def setUp(self):
        self.thread = StoreThread()
        self.thread.start()

    def tearDown(self):
        self.thread.stop()

    def test_cancellable(self):
        def testfunc():
            # FIXME: there is no test to verify that testfunc was not called;
            # it is not easy to come up with a sensible test because
            # dfr.cancel might be executed after that testfunc was called
            pass

        dfr = self.thread.defer_to_thread(testfunc)
        dfr.cancel()
        self.failUnlessFailure(dfr, CancelledError)
        return dfr
