/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef _STRINGUTIL_H
#define _STRINGUTIL_H

#include "platform.h"
#include <string>
#include <vector>
#include <algorithm>

/*
 * Comparison handler for case-insensitive keys in maps
 */
struct stricmp_comparison {
	bool operator()(const std::string &left, const std::string &right) const
	{
		return ((left.size() < right.size()) || ((left.size() == right.size()) && (stricmp(left.c_str(), right.c_str()) < 0)));
	}
};

static inline std::string strToUpper(std::string f) {
	transform(f.begin(), f.end(), f.begin(), ::toupper);
	return f;
}

static inline std::string strToLower(std::string f) {
	transform(f.begin(), f.end(), f.begin(), ::tolower);
	return f;
}

std::wstring towstring(const std::string &s);
std::string tostring(const std::wstring &ws);

// Use casting if passing hard coded values.
std::string stringify(unsigned int x, bool usehex = false);
std::string stringify_int64(long long x, bool usehex = false);
std::string stringify_float(float x);
std::string stringify_double(double x, int prec = 18);
std::string stringify_datetime(time_t x);

std::wstring wstringify(unsigned int x, bool usehex = false);
std::wstring wstringify_int64(long long x, bool usehex = false);
std::wstring wstringify_uint64(unsigned long long x, bool usehex = false);
std::wstring wstringify_float(float x);
std::wstring wstringify_double(double x, int prec = 18);

inline unsigned int	atoui(const char *szString) { return strtoul(szString, NULL, 10); }
unsigned int xtoi(const char *lpszHex);

int memsubstr(const void* haystack, size_t haystackSize, const void* needle, size_t needleSize);

std::string striconv(const std::string &strinput, const char *lpszFromCharset, const char *lpszToCharset);

std::string str_storage(unsigned long long ulBytes, bool bUnlimited = true);

std::string PrettyIP(long unsigned int ip);
std::string GetServerNameFromPath(const char *szPath);
std::string GetServerTypeFromPath(const char *szPath);
std::string GetServerPortFromPath(const char *szPath);
std::string ServerNamePortToURL(const char *lpszType, const char *lpszServerName, const char *lpszServerPort, const char *lpszExtra = "zarafa");

static inline bool parseBool(const std::string &s) {
	return !(s == "0" || s == "false" || s == "no");
}

void strMakeUnicode(const char *lpszA, WCHAR **lpszW);

std::string shell_escape(std::string str);

std::vector<std::string> tokenize(const char *input, const char sep);
std::vector<std::string> tokenize(const std::string &strInput, const std::string &strSep);
std::string concatenate(std::vector<std::string> &elements, const std::string &delimeters);

std::string trim(const std::string &strInput, const std::string &strTrim = " ");

unsigned char x2b(char c);
std::string hex2bin(const std::string &input);
std::string bin2hex(unsigned int inLength, const unsigned char *input);

std::string StringEscape(const char* input, const char *tokens, const char escape);

std::string strUnEscapeHex(std::string strIn);

#endif
